/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class Config {
    private static final Path CONFIG_PATH = EuphoriaPatcher.configDirectory.resolve("euphoria_patcher.properties");
    private static final Properties properties = new Properties();
    private static FileTime lastModified = null;
    private static boolean watcherActive = false;
    private static ScheduledExecutorService scheduler;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[Config] " + message);
    }

    public static void createConfig() {
        try {
            Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            Config.writeInitialConfig();
            EuphoriaPatcher.log(0, "Successfully created config file");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error creating config file: " + e.getMessage());
        }
    }

    private static void writeInitialConfig() throws IOException {
        try (FileWriter writer = new FileWriter(String.valueOf(CONFIG_PATH), false);){
            writer.write("# This file stores configuration options for the Euphoria Patcher mod\n");
            writer.write("# Made for version " + "_1.6.5".replace("_", "") + "\n");
            writer.write("# Thank you for using Euphoria Patches - SpacEagle17\n");
        }
    }

    public static void updateVersionLine() {
        try {
            int headerIndex;
            List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
            boolean versionLineFound = false;
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).startsWith("# Made for version")) continue;
                if (lines.get(i).contains("_1.6.5".replace("_", ""))) {
                    return;
                }
                lines.set(i, "# Made for version " + "_1.6.5".replace("_", ""));
                versionLineFound = true;
                break;
            }
            if (!versionLineFound && (headerIndex = lines.indexOf("# This file stores configuration options for the Euphoria Patcher mod")) >= 0) {
                lines.add(headerIndex + 1, "# Made for version " + "_1.6.5".replace("_", ""));
            }
            Files.write(CONFIG_PATH, lines, StandardCharsets.UTF_8, new OpenOption[0]);
            Config.debugLog("Successfully updated version info in config file");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error updating config file with version: " + e.getMessage());
        }
    }

    public static void writeConfig(String option, String value, String description) {
        block19: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    Config.createConfig();
                } else {
                    Config.updateVersionLine();
                }
                Config.loadProperties();
                if (properties.containsKey(option)) break block19;
                List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
                try (FileWriter writer = new FileWriter(String.valueOf(CONFIG_PATH), false);){
                    for (String line : lines) {
                        writer.write(line + "\n");
                    }
                    writer.write("\n");
                    if (description != null) {
                        String[] descLines;
                        for (String line : descLines = description.split("\n")) {
                            writer.write("# " + line + "\n");
                        }
                    }
                    writer.write(option + "=" + value + "\n");
                    Config.debugLog("Successfully wrote to config file: " + option + "=" + value);
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error writing to config file: " + e.getMessage());
            }
        }
    }

    public static String readWriteConfig(String optionName, String defaultValue, String description) {
        Config.writeConfig(optionName, defaultValue, description);
        return properties.getProperty(optionName, defaultValue);
    }

    public static void loadProperties() {
        try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            properties.load(in);
            lastModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error loading properties: " + e.getMessage());
        }
    }

    public static void startConfigWatcher() {
        if (watcherActive) {
            return;
        }
        watcherActive = true;
        scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "EuphoriaConfigWatcher");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> {
            try {
                FileTime currentModified;
                if (Files.exists(CONFIG_PATH, new LinkOption[0]) && !(currentModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0])).equals(lastModified)) {
                    Config.debugLog("Config file changed, reloading settings");
                    Config.loadProperties();
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.configStuff();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static void stopConfigWatcher() {
        if (watcherActive && scheduler != null) {
            scheduler.shutdown();
            watcherActive = false;
        }
    }
}

