/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.DetachedDrawerTooltip;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientDetachedDrawerTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_SPRITE = ModConstants.loc("textures/gui/detached_tooltip.png");
    private final IDrawer drawer;
    private final ItemStack item;
    private final int stackLimit;

    public ClientDetachedDrawerTooltip(DetachedDrawerTooltip tooltip) {
        this.drawer = tooltip.getDrawer();
        this.item = tooltip.getItem();
        this.stackLimit = tooltip.getStackLimit();
    }

    public int m_142103_() {
        return this.backgroundHeight() + 4;
    }

    public int m_142069_(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return 128;
    }

    private int backgroundHeight() {
        return 24;
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics graphics) {
        boolean forceCapCheck = (Boolean)ModCommonConfig.INSTANCE.DRAWERS.detached.forceMaxCapacityCheck.get();
        int bgY = forceCapCheck ? 0 : 24;
        graphics.m_280163_(BACKGROUND_SPRITE, pX, pY, 0.0f, (float)bgY, this.backgroundWidth(), this.backgroundHeight(), 128, 64);
        this.renderSlot(pX + 3, pY + 3, graphics, font);
        String count = CountFormatter.formatApprox(font, this.drawer);
        graphics.m_280056_(font, count, pX + 22, pY + 8, 0x808080, false);
        if (forceCapCheck) {
            graphics.m_280056_(font, Integer.toString(this.stackLimit), pX + 83, pY + 8, 0x808080, false);
        }
    }

    private void renderSlot(int pX, int pY, GuiGraphics graphics, Font font) {
        ItemStack itemstack = this.item;
        graphics.m_280256_(itemstack, pX + 1, pY + 1, 0);
    }
}

