/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.network.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.init.data.WabTriggers;

public class ServerGliderPartyingPacket {
    private final int entityId;
    private final boolean partying;

    public ServerGliderPartyingPacket(int pEntityId, boolean partying) {
        this.entityId = pEntityId;
        this.partying = partying;
    }

    public ServerGliderPartyingPacket(FriendlyByteBuf pBuffer) {
        this.entityId = pBuffer.readInt();
        this.partying = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.partying);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        Entity entity = context.get().getSender().m_9236_().m_6815_(this.entityId);
        if (entity instanceof Glider) {
            Glider glider = (Glider)entity;
            glider.setPartying(this.partying);
            WabTriggers.triggerNearby(WabTriggers.NEAR_GLIDER_DANCE, (Entity)glider, 8);
        }
    }
}

