/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.gen.assets;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.block.AncientSkull;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.init.world.WabBlocks;

public class WabBlockStateGenerator
extends BlockStateProvider {
    public WabBlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wan_ancient_beasts", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.EATER_EGG.get()));
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.WALKER_EGG.get()));
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.CRUSHER_EGG.get()));
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.GLIDER_EGG.get()));
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.SOARER_EGG.get()));
        this.beastEgg((BeastEggBlock)((Object)WabBlocks.SURFER_EGG.get()));
        this.simpleBlock((Block)WabBlocks.QUICK_SAND.get(), (ModelFile)this.models().getExistingFile(this.resource("quick_sand")));
        this.simpleBlock((Block)WabBlocks.QUICK_RED_SAND.get(), (ModelFile)this.models().getExistingFile(this.resource("quick_red_sand")));
        this.simpleBlock((Block)WabBlocks.FROZEN_STRAW_BLOCK.get(), this.resource("frozen_straw"));
        this.simpleBlock((Block)WabBlocks.STRAW_BLOCK.get(), this.resource("straw"));
        this.stairsBlock((StairBlock)WabBlocks.STRAW_STAIRS.get(), this.resource("straw"));
        this.slabBlock((SlabBlock)WabBlocks.STRAW_SLAB.get(), this.resource("straw_block"), this.resource("straw"));
        this.suspiciousBlock((Block)WabBlocks.SUSPICIOUS_RED_SAND.get());
        this.suspiciousBlock((Block)WabBlocks.SUSPICIOUS_ICE.get());
        this.singleModel((Block)WabBlocks.SNIFFER_SKULL.get());
        this.singleModel((Block)WabBlocks.EATER_SKULL.get());
        this.singleModel((Block)WabBlocks.WALKER_SKULL.get());
        this.singleModel((Block)WabBlocks.CRUSHER_SKULL.get());
        this.singleModel((Block)WabBlocks.GLIDER_SKULL.get());
        this.singleModel((Block)WabBlocks.SOARER_SKULL.get());
        this.singleModel((Block)WabBlocks.CHARGER_SKULL.get());
        this.singleModel((Block)WabBlocks.SURFER_SKULL.get());
    }

    public void simpleBlock(Block block, ResourceLocation texture) {
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), texture));
    }

    public void singleModel(Block block) {
        this.singleModel(block, ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public void singleModel(Block block, ResourceLocation model) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(model));
    }

    public void beastEgg(BeastEggBlock<?> block, ModelFile hatch0, ModelFile hatch1, ModelFile hatch2) {
        this.getVariantBuilder((Block)block).partialState().with((Property)BeastEggBlock.f_278491_, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch0)}).partialState().with((Property)BeastEggBlock.f_278491_, (Comparable)Integer.valueOf(1)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch1)}).partialState().with((Property)BeastEggBlock.f_278491_, (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel(hatch2)});
    }

    public void beastEgg(BeastEggBlock<?> block) {
        String name = ForgeRegistries.BLOCKS.getKey(block).m_135815_();
        AABB bound = block.shape.m_83215_();
        this.beastEgg(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_not_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_not_cracked_north"))).texture("east", this.resource(name + "_not_cracked_east"))).texture("west", this.resource(name + "_not_cracked_west"))).texture("south", this.resource(name + "_not_cracked_south"))).texture("up", this.resource(name + "_not_cracked_top"))).texture("down", this.resource(name + "_not_cracked_bottom"))).element().from((float)bound.f_82288_ * 16.0f, (float)bound.f_82289_ * 16.0f, (float)bound.f_82290_ * 16.0f).to((float)bound.f_82291_ * 16.0f, (float)bound.f_82292_ * 16.0f, (float)bound.f_82293_ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.m_122434_() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.m_82362_() * 16.0f, (float)bound.m_82385_() * 16.0f);
            } else if (direction.m_122434_() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82385_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82362_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            }
            faceBuilder.texture("#" + direction.m_122433_());
        }).end(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_slightly_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_slightly_cracked_north"))).texture("east", this.resource(name + "_slightly_cracked_east"))).texture("west", this.resource(name + "_slightly_cracked_west"))).texture("south", this.resource(name + "_slightly_cracked_south"))).texture("up", this.resource(name + "_slightly_cracked_top"))).texture("down", this.resource(name + "_slightly_cracked_bottom"))).element().from((float)bound.f_82288_ * 16.0f, (float)bound.f_82289_ * 16.0f, (float)bound.f_82290_ * 16.0f).to((float)bound.f_82291_ * 16.0f, (float)bound.f_82292_ * 16.0f, (float)bound.f_82293_ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.m_122434_() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.m_82362_() * 16.0f, (float)bound.m_82385_() * 16.0f);
            } else if (direction.m_122434_() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82385_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82362_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            }
            faceBuilder.texture("#" + direction.m_122433_());
        }).end(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_very_cracked", this.resource("beast_egg"))).texture("north", this.resource(name + "_very_cracked_north"))).texture("east", this.resource(name + "_very_cracked_east"))).texture("west", this.resource(name + "_very_cracked_west"))).texture("south", this.resource(name + "_very_cracked_south"))).texture("up", this.resource(name + "_very_cracked_top"))).texture("down", this.resource(name + "_very_cracked_bottom"))).element().from((float)bound.f_82288_ * 16.0f, (float)bound.f_82289_ * 16.0f, (float)bound.f_82290_ * 16.0f).to((float)bound.f_82291_ * 16.0f, (float)bound.f_82292_ * 16.0f, (float)bound.f_82293_ * 16.0f).allFaces((direction, faceBuilder) -> {
            if (direction.m_122434_() == Direction.Axis.Y) {
                faceBuilder.uvs(0.0f, 0.0f, (float)bound.m_82362_() * 16.0f, (float)bound.m_82385_() * 16.0f);
            } else if (direction.m_122434_() == Direction.Axis.X) {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82385_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            } else {
                faceBuilder.uvs(0.0f, (float)(16.0 - bound.m_82376_() * 16.0), (float)bound.m_82362_() * 16.0f, (float)bound.m_82376_() * 16.0f);
            }
            faceBuilder.texture("#" + direction.m_122433_());
        }).end());
    }

    public void suspiciousBlock(Block block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.suspiciousBlock(block, (ModelFile)this.models().cubeAll(name + "_0", this.resource(name + "_0")), (ModelFile)this.models().cubeAll(name + "_1", this.resource(name + "_1")), (ModelFile)this.models().cubeAll(name + "_2", this.resource(name + "_2")), (ModelFile)this.models().cubeAll(name + "_3", this.resource(name + "_3")));
    }

    public void suspiciousBlock(Block block, ModelFile dusted0, ModelFile dusted1, ModelFile dusted2, ModelFile dusted3) {
        this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted0)}).partialState().with((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(1)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted1)}).partialState().with((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted2)}).partialState().with((Property)BlockStateProperties.f_271112_, (Comparable)Integer.valueOf(3)).addModels(new ConfiguredModel[]{new ConfiguredModel(dusted3)});
    }

    public void ancientSkull(AncientSkull block) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(name, this.resource("ancient_skull"))).texture("particle", this.resource(name)));
    }

    private ResourceLocation resource(String name) {
        return WanAncientBeasts.resource("block/" + name);
    }
}

