/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.part;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class WabEntityPart<T extends LivingEntity>
extends PartEntity<T> {
    protected T mob;
    protected final float width;
    protected final float height;
    protected final float distance;
    protected final float relY;
    protected final float relAngle;

    public WabEntityPart(T mob, float width, float height, float distance, float relY) {
        this(mob, width, height, distance, relY, 0.0f);
    }

    public WabEntityPart(T mob, float width, float height, float distance, float relY, float relAngle) {
        super(mob);
        this.mob = mob;
        this.width = width;
        this.height = height;
        this.distance = distance;
        this.relY = relY;
        this.relAngle = relAngle;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.mob.m_142340_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !this.m_6673_(source) && this.mob.m_6469_(source, amount);
    }

    public InteractionResult m_6096_(Player p_19978_, InteractionHand p_19979_) {
        return this.mob.m_6096_(p_19978_, p_19979_);
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.mob == entity;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.width, (float)this.height);
    }

    public void update() {
        this.updatePos();
        this.updateBoundingBox();
    }

    public void updatePos() {
        Vec3 vec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_6034_(this.mob.m_20185_() + (double)this.getDistance() * Math.cos(Math.toRadians(this.getRotation() + this.relAngle + 90.0f)), this.mob.m_20186_() + (double)this.getRelY(), this.mob.m_20189_() + (double)this.getDistance() * Math.sin(Math.toRadians(this.getRotation() + this.relAngle + 90.0f)));
        this.f_19854_ = vec.f_82479_;
        this.f_19855_ = vec.f_82480_;
        this.f_19856_ = vec.f_82481_;
        this.f_19790_ = vec.f_82479_;
        this.f_19791_ = vec.f_82480_;
        this.f_19792_ = vec.f_82481_;
    }

    public void updateBoundingBox() {
        float width = this.getWidth();
        float height = this.getHeight();
        this.m_20011_(new AABB(this.m_20185_() - (double)(width / 2.0f), this.m_20186_(), this.m_20189_() - (double)(width / 2.0f), this.m_20185_() + (double)(width / 2.0f), this.m_20186_() + (double)height, this.m_20189_() + (double)(width / 2.0f)));
    }

    public boolean m_142391_() {
        return false;
    }

    public float getRotation() {
        return ((LivingEntity)this.mob).f_20883_;
    }

    public float getWidth() {
        return this.mob.m_6162_() ? this.width * 0.4f : this.width;
    }

    public float getHeight() {
        return this.mob.m_6162_() ? this.height * 0.4f : this.height;
    }

    public float getDistance() {
        return this.mob.m_6162_() ? this.distance * 0.4f : this.distance;
    }

    public float getRelY() {
        return this.mob.m_6162_() ? this.relY * 0.4f : this.relY;
    }
}

