/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.config.WabWorldConfig;
import net.wanmine.wab.entity.goals.surfer.SurferCheckRelaxingGoal;
import net.wanmine.wab.entity.goals.surfer.SurferPanicGoal;
import net.wanmine.wab.entity.goals.surfer.SurferRandomStrollGoal;
import net.wanmine.wab.entity.goals.surfer.SurferTemptGoal;
import net.wanmine.wab.entity.part.WabEntityPart;
import net.wanmine.wab.entity.part.surfer.SurferHead;
import net.wanmine.wab.entity.part.surfer.SurferNeck;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabBlocks;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabSounds;
import net.wanmine.wab.item.SurferArmor;
import net.wanmine.wab.network.PacketHandler;
import net.wanmine.wab.network.client.InitSurferPacket;
import net.wanmine.wab.network.server.SurferJumpPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Surfer
extends AbstractHorse
implements GeoEntity {
    public static final String ID = "surfer";
    public static final String SPAWN_EGG_ID = "surfer_spawn_egg";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("552E1865-8B10-40B8-8F9D-CF9B4767A895");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_ARMOR = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RELAXING = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BE_TAMED = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_JUMPING = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> CORAL_COLOR = SynchedEntityData.m_135353_(Surfer.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final RawAnimation BABY = RawAnimation.begin().thenPlay("misc.baby");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int COLOR_START_TO_CHANGE = 32;
    public static final int COLOR_CHANGE = 64;
    public static final float COLOR_CHANGE_PROBABILITY = 0.03f;
    public static final int MIN_RELAXING_TIME = -12000;
    public static final int FRIENDLY_TIME_AFTER_RELAX = -600;
    public static final int OXYGEN_SUPPLY = 1200;
    private String coralColor = "base";
    private int coralEatenCount = 0;
    private String coralColorEating = "base";
    private int relaxedTime = 0;
    private Vec3 approachingPlayerPos = null;
    private boolean approachingPlayer = false;
    private boolean isLandingJump = false;
    private int abortJumpIn = -1;
    private int oxygen = 3600;
    private Vec3 jumpVec = null;
    private final WabEntityPart<Surfer>[] subEntities;
    private final SurferNeck neck = new SurferNeck(this);
    private final SurferHead head = new SurferHead(this);
    private final WabEntityPart<Surfer> tail = new WabEntityPart<Surfer>(this, 1.0f, 0.5f, 1.0f, 0.1f, 180.0f);
    private int tickLeft = 0;

    public Surfer(EntityType<? extends AbstractHorse> animal, Level level) {
        super(animal, level);
        this.subEntities = new WabEntityPart[]{this.neck, this.head, this.tail};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 8, 1.0f, 1.0f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)WabWorldConfig.SURFER_HEALTH.get()).doubleValue());
        this.m_21153_(((Double)WabWorldConfig.SURFER_HEALTH.get()).floatValue());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22288_, 0.6).m_22268_(Attributes.f_22279_, 0.1).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 8.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(HAS_ARMOR, (Object)false);
        this.f_19804_.m_135372_(IS_RELAXING, (Object)false);
        this.f_19804_.m_135372_(CAN_BE_TAMED, (Object)false);
        this.f_19804_.m_135372_(IS_RUNNING, (Object)false);
        this.f_19804_.m_135372_(IS_JUMPING, (Object)false);
        this.f_19804_.m_135372_(CORAL_COLOR, (Object)"base");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            pCompound.m_128365_("ArmorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
        pCompound.m_128359_("coralColor", this.coralColor);
        pCompound.m_128405_("coralEatenCount", this.coralEatenCount);
        pCompound.m_128359_("coralColorEating", this.coralColorEating);
        pCompound.m_128405_("relaxedTime", this.relaxedTime);
        pCompound.m_128405_("oxygen", this.oxygen);
    }

    public void m_7378_(CompoundTag pCompound) {
        ItemStack itemstack;
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("ArmorItem"))).m_41619_() && this.m_6010_(itemstack)) {
            this.f_30520_.m_6836_(1, itemstack);
        }
        this.coralColor = pCompound.m_128441_("coralColor") ? pCompound.m_128461_("coralColor") : "base";
        this.coralEatenCount = pCompound.m_128451_("coralEatenCount");
        this.coralColorEating = pCompound.m_128441_("coralColorEating") ? pCompound.m_128461_("coralColorEating") : "base";
        this.relaxedTime = pCompound.m_128451_("relaxedTime");
        this.oxygen = pCompound.m_128441_("oxygen") ? pCompound.m_128451_("oxygen") : 3600;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.f_19804_.m_135381_(IS_RELAXING, (Object)(this.relaxedTime > 0 ? 1 : 0));
        this.f_19804_.m_135381_(CAN_BE_TAMED, (Object)(!this.m_30614_() && this.relaxedTime > -600 && this.relaxedTime < -State.RELAX_TO_IDLE.duration && !this.approachingPlayer ? 1 : 0));
        this.f_19804_.m_135381_(HAS_ARMOR, (Object)super.m_7481_());
        PacketHandler.sendToPlayer(new InitSurferPacket(this.m_19879_(), this.coralColor), player);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_41868_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SurferPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new BreedGoal((Animal)this, 1.0)));
        this.f_21345_.m_25352_(3, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41868_}), false)));
        this.f_21345_.m_25352_(4, (Goal)new SurferTemptGoal(this, 1.0, Ingredient.m_204132_(WabTags.Items.SURFER_FOOD), false));
        this.f_21345_.m_25352_(5, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new FollowParentGoal((Animal)this, 1.0)));
        this.f_21345_.m_25352_(6, (Goal)new SurferRandomStrollGoal(this, 1.0, 30));
        this.f_21345_.m_25352_(7, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.6f)));
        this.f_21345_.m_25352_(8, (Goal)new SurferCheckRelaxingGoal(this, (Goal)new RandomLookAroundGoal((Mob)this)));
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)WabEntities.SURFER.get()).m_20615_((Level)level);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        ItemStack itemstack = new ItemStack((ItemLike)((BeastEggBlock)((Object)WabBlocks.SURFER_EGG.get())).m_5456_());
        ItemEntity itementity = new ItemEntity((Level)level, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(level, mate, null);
        this.m_5496_(SoundEvents.f_279531_, 1.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        level.m_7967_((Entity)itementity);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_30616_()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else if (this.m_20069_()) {
            this.m_19920_(this.getWaterSpeed(), travelVector);
            Vec3 currentMotion = this.m_20184_();
            double targetYVelocity = 0.0;
            if (this.m_21573_().m_26572_()) {
                Path path = this.m_21573_().m_26570_();
                if (path != null && !path.m_77392_()) {
                    double dy = (double)path.m_77401_().f_77272_ - this.m_20186_();
                    targetYVelocity = Math.signum(dy) * 0.03;
                }
            } else if (this.f_19796_.m_188501_() < 0.5f) {
                targetYVelocity = this.m_20160_() ? -0.002 : 0.005;
            }
            this.m_20334_(currentMotion.f_82479_, targetYVelocity + currentMotion.f_82480_, currentMotion.f_82481_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public float getWaterSpeed() {
        return this.m_6113_() * 1.8f * (this.m_7481_() ? 0.85f : 1.0f) * (this.m_20142_() ? 1.3f : 1.0f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.isRelaxing()) {
            if (!this.m_9236_().f_46443_) {
                this.setRelaxingTime(0);
                if (!this.approachingPlayer && !this.m_30614_()) {
                    this.f_19804_.m_135381_(CAN_BE_TAMED, (Object)true);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_36341_() && this.m_30614_()) {
            this.m_213583_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_ && !this.m_6162_() && this.m_6898_(itemstack) && this.m_5957_()) {
            this.m_142075_(player, hand, itemstack);
            this.m_27595_(player);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(WabTags.Items.SURFER_FOOD) && (this.m_30614_() || this.canBeTamed() || this.m_6162_())) {
            boolean flag = false;
            if (this.getCoralColor().equals("base")) {
                if (!this.m_9236_().f_46443_) {
                    if (this.coralEatenCount <= 0) {
                        this.coralColorEating = Surfer.coralToColor(itemstack.m_41720_());
                        this.coralEatenCount = 1;
                    } else if (this.coralColorEating.equals(Surfer.coralToColor(itemstack.m_41720_()))) {
                        this.coralEatenCount = Math.min(this.coralEatenCount + 1, 64);
                        if (this.coralEatenCount == 64 || this.coralEatenCount >= 32 && this.f_19796_.m_188501_() <= 0.03f) {
                            this.setCoralColor(Surfer.coralToColor(itemstack.m_41720_()));
                        }
                    } else {
                        this.coralEatenCount = Math.max(this.coralEatenCount - 3, 0);
                    }
                }
                flag = true;
            } else if (this.getCoralColor().equals(Surfer.coralToColor(itemstack.m_41720_()))) {
                flag = true;
            }
            if (flag) {
                if (this.m_6162_()) {
                    this.m_146740_(Surfer.m_216967_((int)(-this.m_146764_())), true);
                } else if (!this.m_9236_().f_46443_ && !this.m_30614_()) {
                    if (this.f_19796_.m_188503_(5) == 0) {
                        this.m_30637_(player);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                this.m_142075_(player, hand, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_30614_()) {
            if (!itemstack.m_41619_()) {
                InteractionResult interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand);
                if (interactionresult.m_19077_()) {
                    return interactionresult;
                }
                if (!this.m_6254_() && itemstack.m_150930_(Items.f_42450_)) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5853_(SoundSource.PLAYERS);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.m_7482_() && this.m_6010_(itemstack) && !this.m_7481_()) {
                    this.m_246861_(player, itemstack);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_8107_() {
        super.m_8107_();
        for (WabEntityPart<Surfer> part : this.subEntities) {
            part.update();
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        ItemStack armor;
        if (!this.m_9236_().f_46443_ && this.isRelaxing()) {
            this.setRelaxingTime(0);
        }
        if (!(armor = this.getArmor()).m_41619_()) {
            armor.m_41622_(1, (LivingEntity)this, e -> {});
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_6123_(Player player) {
        if (!this.m_9236_().f_46443_ && this.isRelaxing()) {
            this.setRelaxingTime(0);
        }
    }

    public void giveOxygenSupply(Player player) {
        if (player.m_20072_() && player.m_20146_() < 300) {
            if (this.oxygen >= 1200) {
                player.m_20301_(300);
                this.oxygen -= 1200;
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"key.messages.wan_ancient_beasts.special_ability.not_enough_oxygen"), true);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.tickLeft > 0) {
                --this.tickLeft;
            }
        } else {
            if (this.relaxedTime < -600) {
                this.approachingPlayer = false;
                this.f_19804_.m_135381_(CAN_BE_TAMED, (Object)false);
            }
            if (this.relaxedTime > 0 && !this.m_30614_()) {
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(12.0, 6.0, 12.0))) {
                    if (player.m_6047_() || player.m_7500_() || player.m_5833_()) continue;
                    if (this.approachingPlayerPos != null && (this.approachingPlayerPos.f_82479_ != player.m_20185_() || this.approachingPlayerPos.f_82481_ != player.m_20189_())) {
                        this.setRelaxingTime(0);
                        this.approachingPlayer = true;
                        this.approachingPlayerPos = null;
                    }
                    this.approachingPlayerPos = player.m_20182_();
                    break;
                }
            }
            this.oxygen = Math.min(this.oxygen + (this.m_20069_() ? 1 : 2), 3600);
            this.setRelaxingTime(Math.max(this.relaxedTime - 1, -12000));
            if ((this.m_9236_().m_46462_() || this.m_9236_().m_46758_(this.m_20183_())) && this.relaxedTime > 0) {
                this.setRelaxingTime(0);
            }
            if (this.abortJumpIn > 0) {
                this.abortJumpIn = Math.max(this.abortJumpIn - 1, 0);
                if (this.abortJumpIn == 0) {
                    this.m_30655_(false);
                    this.isLandingJump = false;
                    this.jumpVec = null;
                    this.abortJumpIn = -1;
                }
                if (this.m_30616_() && !this.m_20072_()) {
                    this.jumpVec = this.jumpVec.m_82546_(new Vec3(0.0, 0.08, 0.0));
                    if (this.jumpVec.f_82480_ < 0.0) {
                        this.m_30655_(false);
                        this.isLandingJump = true;
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WabSounds.SURFER_JUMP_LANDING.get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_() * 0.8f, this.m_6100_());
                    }
                } else if (this.isLandingJump) {
                    this.jumpVec = this.jumpVec.m_82546_(new Vec3(0.0, 0.08, 0.0));
                    if (this.m_20072_()) {
                        this.isLandingJump = false;
                        this.jumpVec = null;
                        this.abortJumpIn = -1;
                    }
                }
                if (this.jumpVec != null) {
                    this.m_20256_(this.jumpVec);
                }
            }
        }
    }

    protected float m_6059_() {
        if (!this.isInWaterOrAbove()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (this.isRunning() ? WabSounds.SURFER_RUN : WabSounds.SURFER_WALK).get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_() * 0.1f, this.m_6100_());
        } else {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5501_(), SoundSource.NEUTRAL, this.m_6121_() * 0.08f, this.m_6100_());
        }
        return super.m_6059_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Surfer.baby(this)});
        controller.add(new AnimationController[]{Surfer.move(this)});
    }

    private static <T extends LivingEntity> AnimationController<T> baby(T entity) {
        return new AnimationController(entity, "baby", 1, state -> {
            if (entity.m_6162_()) {
                return state.setAndContinue(BABY);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    private static AnimationController<Surfer> move(Surfer surfer) {
        return new AnimationController((GeoAnimatable)surfer, "move", 1, state -> {
            if (surfer.tickLeft <= 0) {
                if (surfer.isRelaxing()) {
                    surfer.setState(State.RELAX);
                } else if (surfer.m_30616_()) {
                    surfer.setState(State.JUMP);
                } else if (surfer.isInWaterOrAbove() && (!surfer.m_20096_() || surfer.m_20072_())) {
                    if (surfer.isMoving()) {
                        if (surfer.isRunning()) {
                            surfer.setState(State.FAST_SWIM);
                        } else {
                            surfer.setState(State.SWIM);
                        }
                    } else {
                        surfer.setState(State.IDLE_WATER);
                    }
                } else if (surfer.isMoving()) {
                    if (surfer.isRunning()) {
                        surfer.setState(State.RUN);
                    } else {
                        surfer.setState(State.WALK);
                    }
                } else {
                    surfer.setState(State.IDLE);
                }
            }
            return state.setAndContinue(surfer.getState().getAnimation());
        });
    }

    public int distanceFromSurface() {
        int distance = 0;
        while (this.m_9236_().m_46801_(this.m_20183_().m_6630_(distance))) {
            ++distance;
        }
        return distance;
    }

    public boolean isMoving() {
        return this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0;
    }

    public boolean isInWaterOrAbove() {
        return this.m_20072_() || this.m_9236_().m_46801_(this.m_20183_().m_7495_());
    }

    public void setRunning(boolean running) {
        this.f_19804_.m_135381_(IS_RUNNING, (Object)running);
    }

    public boolean isRunning() {
        return this.m_20142_() || (Boolean)this.f_19804_.m_135370_(IS_RUNNING) != false;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        if (state == State.RELAX && this.getState() != State.RELAX && this.getState() != State.IDLE_TO_RELAX) {
            state = State.IDLE_TO_RELAX;
        } else if (state != State.RELAX && this.getState() == State.RELAX) {
            state = State.RELAX_TO_IDLE;
        } else if (state == State.JUMP && this.getState() != State.JUMP && this.getState() != State.JUMP_START) {
            state = State.JUMP_START;
        } else if (state != State.JUMP && this.getState() == State.JUMP) {
            state = State.JUMP_END;
        }
        this.tickLeft = state.getDuration();
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        if (this.m_20072_()) {
            return new Vec3(0.0, (double)(Math.max(Math.min(player.m_146909_() / 2.0f, 25.0f), -25.0f) / -20.0f * Math.max(player.f_20902_, 0.0f)), (double)Math.max(player.f_20902_, 0.0f));
        }
        return new Vec3(0.0, 0.0, (double)Math.max(player.f_20902_, 0.0f));
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.25f * (this.isInWaterOrAbove() ? (this.m_20142_() ? 0.7f : 0.9f) : (this.m_20142_() ? 1.2f : 1.0f));
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = new Vec3(0.0, 0.1, -0.2).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        this.clampRotation(entity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        if (!this.m_30616_()) {
            Vec2 vec2 = this.m_274391_((LivingEntity)player);
            this.m_19915_(vec2.f_82471_, vec2.f_82470_);
            this.f_20883_ = this.f_20885_ = this.m_146908_();
            this.f_19859_ = this.f_20885_;
            this.m_6858_(player.m_20142_());
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.m_5618_(this.m_146908_());
        float f = pEntity.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.m_146922_(f3);
        pEntity.m_5616_(f3);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6107_() {
        return super.m_6107_() || this.isRelaxing();
    }

    public boolean m_5829_() {
        return this.isRelaxing();
    }

    public boolean m_7482_() {
        return true;
    }

    public void m_246861_(Player player, ItemStack itemStack) {
        super.m_246861_(player, itemStack);
        this.m_7493_();
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        this.f_19804_.m_135381_(HAS_ARMOR, (Object)this.m_6010_(itemStack));
    }

    protected void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.setArmorEquipment(this.f_30520_.m_8020_(1));
        }
    }

    private void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            int protection;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            if (this.m_6010_(itemStack) && (protection = ((SurferArmor)itemStack.m_41720_()).getProtection()) != 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Surfer armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean m_7481_() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ARMOR);
    }

    public boolean m_6010_(ItemStack itemStack) {
        return itemStack.m_150930_((Item)WabItems.SURFER_ARMOR.get());
    }

    public boolean m_7132_() {
        return super.m_7132_() && this.isInWaterOrAbove() && !this.m_30616_() && this.distanceFromSurface() <= 5;
    }

    public boolean m_30616_() {
        return (Boolean)this.f_19804_.m_135370_(IS_JUMPING);
    }

    public void m_30655_(boolean isJumping) {
        super.m_30655_(isJumping);
        this.f_19804_.m_135381_(IS_JUMPING, (Object)isJumping);
    }

    public void m_7888_(int power) {
        PacketHandler.sendToServer(new SurferJumpPacket(this.m_19879_(), power));
    }

    public void jump(int power) {
        if (this.m_7132_() && this.abortJumpIn == -1) {
            this.m_30655_(true);
            double radians = Math.toRadians(this.m_6688_().m_146908_());
            this.jumpVec = new Vec3(-Math.sin(radians) * (0.15 + (double)power / 200.0), 0.2 + (double)power / 200.0, Math.cos(radians) * (0.15 + (double)power / 200.0));
            this.abortJumpIn = 30;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WabSounds.SURFER_JUMP_START.get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_() * 0.5f, this.m_6100_());
        }
    }

    public boolean m_264410_() {
        return true;
    }

    public void m_6858_(boolean sprinting) {
        if (!this.m_9236_().f_46443_ && !this.m_20142_() && sprinting) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WabSounds.SURFER_ROAR.get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
        }
        super.m_6858_(sprinting);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(id + i + 1);
        }
    }

    public boolean m_7848_(Animal animal) {
        if (animal instanceof Surfer) {
            Surfer surfer = (Surfer)animal;
            return this != surfer && this.m_30628_() && surfer.m_30628_();
        }
        return false;
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7559_() {
        return false;
    }

    public MobType m_6336_() {
        return WabEntities.ANCIENT_MOB;
    }

    public boolean isApproachingPlayer() {
        return this.approachingPlayer;
    }

    public static String coralToColor(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_().replace("_coral_fan", "");
    }

    public boolean isRelaxing() {
        return (Boolean)this.f_19804_.m_135370_(IS_RELAXING);
    }

    public boolean isAwake() {
        return this.relaxedTime < -State.RELAX_TO_IDLE.getDuration();
    }

    public void setRelaxingTime(int time) {
        if (time > 0 && this.relaxedTime <= 0) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WabSounds.SURFER_IDLE_TO_RELAX.get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
        } else if (time <= 0 && this.relaxedTime > 0) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WabSounds.SURFER_RELAX_TO_IDLE.get(this.m_6162_()), SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
        }
        this.relaxedTime = time;
        this.f_19804_.m_135381_(IS_RELAXING, (Object)(this.relaxedTime > 0 ? 1 : 0));
    }

    public int getRelaxingTime() {
        return this.relaxedTime;
    }

    public boolean canBeTamed() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BE_TAMED);
    }

    public void setCoralColor(String color) {
        this.coralColor = color;
        this.f_19804_.m_135381_(CORAL_COLOR, (Object)color);
    }

    public String getCoralColor() {
        return (String)this.f_19804_.m_135370_(CORAL_COLOR);
    }

    public void m_5757_(Container container) {
        ItemStack oldArmor = this.getArmor();
        super.m_5757_(container);
        ItemStack armor = this.getArmor();
        if (this.f_19797_ > 20 && this.m_6010_(armor) && oldArmor != armor) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    protected void m_5877_(SoundType soundType) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isRelaxing()) {
            return WabSounds.SURFER_RELAX.get(this.m_6162_());
        }
        return this.isInWaterOrAbove() ? WabSounds.SURFER_IDLE_WATER.get(this.m_6162_()) : WabSounds.SURFER_IDLE.get(this.m_6162_());
    }

    protected SoundEvent m_5501_() {
        return this.isRunning() ? WabSounds.SURFER_FAST_SWIM.get(this.m_6162_()) : WabSounds.SURFER_SWIM.get(this.m_6162_());
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)WabSounds.SURFER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return WabSounds.SURFER_DEATH.get(this.m_6162_());
    }

    protected float m_6121_() {
        return 0.9f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State {
        IDLE(RawAnimation.begin().thenPlay("misc.idle"), true),
        WALK(RawAnimation.begin().thenPlay("move.walk"), true),
        RUN(RawAnimation.begin().thenPlay("move.run"), true),
        IDLE_TO_RELAX(RawAnimation.begin().thenPlay("misc.idle_to_relax"), false, 10),
        RELAX(RawAnimation.begin().thenPlay("misc.relax"), false),
        RELAX_TO_IDLE(RawAnimation.begin().thenPlay("misc.relax_to_idle"), false, 15),
        IDLE_WATER(RawAnimation.begin().thenPlay("misc.idle_water"), true),
        SWIM(RawAnimation.begin().thenPlay("move.swim"), false),
        FAST_SWIM(RawAnimation.begin().thenPlay("move.fast_swim"), false),
        JUMP_START(RawAnimation.begin().thenPlay("jump.start"), false, 10),
        JUMP(RawAnimation.begin().thenPlay("jump.pose"), false),
        JUMP_END(RawAnimation.begin().thenPlay("jump.end"), false, 15);

        private final RawAnimation animation;
        private final boolean turnHead;
        private final int duration;

        private State(RawAnimation animation, boolean turnHead) {
            this(animation, turnHead, 0);
        }

        private State(RawAnimation animation, boolean turnHead, int duration) {
            this.animation = animation;
            this.turnHead = turnHead;
            this.duration = duration;
        }

        public RawAnimation getAnimation() {
            return this.animation;
        }

        public boolean canTurnHead() {
            return this.turnHead;
        }

        public int getDuration() {
            return this.duration;
        }
    }
}

