/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.core.init;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.reaper.vanimals.common.item.FuelItem;
import net.reaper.vanimals.common.item.NauseaItem;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VFoods;
import net.reaper.vanimals.core.init.VSoundEvents;

public class VItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"vanimals");
    public static final RegistryObject<Item> BISON_FUR = ITEMS.register("bison_fur", () -> new FuelItem(new Item.Properties(), 20));
    public static final RegistryObject<Item> BISON_HORN = ITEMS.register("bison_horn", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> APPLE_ON_A_STICK = ITEMS.register("apple_on_a_stick", () -> new Item(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> FOUREYED_FISH_EYE = ITEMS.register("foureyed_fish_eye", () -> new NauseaItem(new Item.Properties().m_41489_(VFoods.FOUREYED_FISH_EYE)));
    public static final RegistryObject<Item> RAW_BISON = ITEMS.register("raw_bison", () -> new Item(new Item.Properties().m_41489_(VFoods.RAW_BISON)));
    public static final RegistryObject<Item> RAW_FOUREYED_FISH = ITEMS.register("raw_foureyed_fish", () -> new Item(new Item.Properties().m_41489_(VFoods.RAW_FOUREYED_FISH)));
    public static final RegistryObject<Item> RAW_MUDSKIPPER = ITEMS.register("raw_mudskipper", () -> new NauseaItem(new Item.Properties().m_41489_(VFoods.RAW_MUDSKIPPER)));
    public static final RegistryObject<Item> COOKED_BISON = ITEMS.register("cooked_bison", () -> new Item(new Item.Properties().m_41489_(VFoods.COOKED_BISON)));
    public static final RegistryObject<Item> COOKED_FOUREYED_FISH = ITEMS.register("cooked_foureyed_fish", () -> new Item(new Item.Properties().m_41489_(VFoods.COOKED_FOUREYED_FISH)));
    public static final RegistryObject<Item> COOOKED_MUDSKIPPER = ITEMS.register("cooked_mudskipper", () -> new Item(new Item.Properties().m_41489_(VFoods.COOKED_MUDSKIPPER)));
    public static final RegistryObject<Item> BISON_SPAWN_EGG;
    public static final RegistryObject<Item> FOUREYED_FISH_SPAWN_EGG;
    public static final RegistryObject<Item> MUDSKIPPER_SPAWN_EGG;
    public static final RegistryObject<Item> NAPOLEON_FISH_SPAWN_EGG;
    public static final RegistryObject<MobBucketItem> FOUREYED_FISH_BUCKET;
    public static final RegistryObject<MobBucketItem> MUDSKIPPER_BUCKET;
    public static final RegistryObject<Item> MUDDY_MELODY_DISC;

    public static <T extends Mob> RegistryObject<Item> registerSpawnEgg(String pMobName, RegistryObject<EntityType<T>> pEntity, Color pBackgroundColor, Color pHighlightColor) {
        return ITEMS.register(pMobName + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)pEntity, pBackgroundColor.hashCode(), pHighlightColor.hashCode(), new Item.Properties()));
    }

    static {
        FOUREYED_FISH_BUCKET = ITEMS.register("foureyed_fish_bucket", () -> new MobBucketItem(VEntityTypes.FOUR_EYED_FISH, () -> Fluids.f_76193_, () -> SoundEvents.f_11782_, new Item.Properties().m_41487_(1)));
        MUDSKIPPER_BUCKET = ITEMS.register("mudskipper_bucket", () -> new MobBucketItem(VEntityTypes.MUDSKIPPER, () -> Fluids.f_76193_, () -> SoundEvents.f_11782_, new Item.Properties().m_41487_(1)));
        BISON_SPAWN_EGG = VItems.registerSpawnEgg("bison", VEntityTypes.BISON, new Color(82, 58, 46), new Color(152, 121, 62));
        FOUREYED_FISH_SPAWN_EGG = VItems.registerSpawnEgg("foureyed_fish", VEntityTypes.FOUR_EYED_FISH, new Color(147, 121, 91), new Color(109, 75, 61));
        MUDSKIPPER_SPAWN_EGG = VItems.registerSpawnEgg("mudskipper", VEntityTypes.MUDSKIPPER, new Color(50, 51, 58), new Color(68, 92, 97));
        NAPOLEON_FISH_SPAWN_EGG = VItems.registerSpawnEgg("napoleon_fish", VEntityTypes.NAPOLEON_FISH, new Color(56, 180, 178), new Color(50, 158, 103));
        MUDDY_MELODY_DISC = ITEMS.register("muddy_melody_disc", () -> new RecordItem(6, VSoundEvents.MUDDY_MELODY_DISC, new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE), 1200));
    }
}

