/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.core.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.vanimals.core.datagen.client.ModBlockStatesProvider;
import net.reaper.vanimals.core.datagen.client.ModEnglishLanguageProvider;
import net.reaper.vanimals.core.datagen.client.ModItemModelsProvider;
import net.reaper.vanimals.core.datagen.client.ModLootTableProvider;
import net.reaper.vanimals.core.datagen.client.ModRecipeProvider;
import net.reaper.vanimals.core.datagen.client.ModSoundProvider;
import net.reaper.vanimals.core.datagen.client.VWorldGenProvider;
import net.reaper.vanimals.core.datagen.server.ModBlockTagsProvider;
import net.reaper.vanimals.core.datagen.server.ModItemTagProvider;

@Mod.EventBusSubscriber(modid="vanimals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        ModBlockTagsProvider blockTagGenerator = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModEnglishLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStatesProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModSoundProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new VWorldGenProvider(packOutput, lookupProvider));
    }
}

