/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.water;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.entity.base.AbstractWaterAnimal;
import net.reaper.vanimals.common.entity.goals.DifferentGenderBreedGoal;
import net.reaper.vanimals.common.enums.Gender;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.util.compound.CompoundType;
import net.reaper.vanimals.util.compound.EntityData;
import org.jetbrains.annotations.NotNull;

public class NapoleonFishEntity
extends AbstractWaterAnimal {
    public static final EntityData<Integer> EMOTION = new EntityData<Integer>(NapoleonFishEntity.class, "EmotionId", CompoundType.INTEGER, 0);

    public NapoleonFishEntity(EntityType<? extends AbstractWaterAnimal> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractAnimal>)pEntityType, pLevel);
        this.setEmotion(Emotion.DEFAULT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractWaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 15));
        this.f_21345_.m_25352_(1, (Goal)new NapoleonNearCoralGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowMaleNapoleonFishGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DifferentGenderBreedGoal((Animal)this, 1.0));
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    protected DietBuilder createDiet() {
        return new DietBuilder().addFood((ItemLike)Items.f_42281_).addFood((ItemLike)Items.f_42295_).addFood((ItemLike)Items.f_42359_).addFood((ItemLike)Items.f_42296_).addFood((ItemLike)Items.f_42360_).addFood((ItemLike)Items.f_42282_).addFood((ItemLike)Items.f_41866_).addFood((ItemLike)Items.f_42297_).addFood((ItemLike)Items.f_42361_).addFood((ItemLike)Items.f_42283_).addFood((ItemLike)Items.f_42298_).addFood((ItemLike)Items.f_42362_).addFood((ItemLike)Items.f_42284_).addFood((ItemLike)Items.f_42299_).addFood((ItemLike)Items.f_42280_).addFood((ItemLike)Items.f_42358_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        EMOTION.define((Entity)this);
    }

    public void m_6075_() {
        int isX = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(isX);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        EMOTION.write((Entity)this, pCompound);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        EMOTION.read((Entity)this, pCompound);
    }

    @Override
    protected void setupAnimations() {
        if (this.flipAnimationTimeout <= 0 && !this.m_20072_()) {
            this.flipAnimationTimeout = 30;
            this.flipAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.flipAnimationTimeout;
        }
        if (this.m_20072_() || this.flipAnimationTimeout <= 0) {
            this.flipAnimationState.m_216973_();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_21224_() || !this.m_20072_()) {
            this.setEmotion(Emotion.SCARY);
        }
        if (this.getEmotion().equals((Object)Emotion.SCARY)) {
            this.m_6858_(true);
            this.m_7910_(0.3f);
        }
        if (this.m_20072_()) {
            this.m_20282_(true);
        }
        if (!this.m_21224_() || this.m_20072_()) {
            this.setEmotion(Emotion.DEFAULT);
        }
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(600);
        }
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)VEntityTypes.NAPOLEON_FISH.get()).m_20615_((Level)pLevel);
    }

    public Emotion getEmotion() {
        return Emotion.values()[EMOTION.get((Entity)this)];
    }

    public void setEmotion(Emotion pEmotion) {
        EMOTION.set((Entity)this, pEmotion.ordinal());
    }

    public static boolean canSpawn(EntityType<NapoleonFishEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.m_8055_(pos).m_60819_().getFluidType() == Fluids.f_76193_.getFluidType() && iServerWorld.m_8055_(pos.m_7494_()).m_60819_().getFluidType() == Fluids.f_76193_.getFluidType() && NapoleonFishEntity.m_186209_((BlockAndTintGetter)iServerWorld, (BlockPos)pos);
    }

    public static enum Emotion {
        DEFAULT,
        EAT,
        SCARY;

    }

    static class NapoleonNearCoralGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final NapoleonFishEntity napoleon;

        NapoleonNearCoralGoal(NapoleonFishEntity pNapoleon, double pSpeedModifier) {
            super((PathfinderMob)pNapoleon, pNapoleon.m_6162_() ? 2.0 : pSpeedModifier, 24);
            this.napoleon = pNapoleon;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return this.napoleon.m_20072_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.napoleon.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.napoleon.m_20072_()) {
                return super.m_8036_();
            }
            return this.napoleon.m_20072_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, @NotNull BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_50585_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50595_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50553_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50563_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50586_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50596_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50554_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50564_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50587_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50597_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50555_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50565_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50588_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50598_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50556_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50566_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50584_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50594_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50552_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50562_);
        }
    }

    public static class FollowMaleNapoleonFishGoal
    extends Goal {
        public static final int HORIZONTAL_SCAN_RANGE = 8;
        public static final int VERTICAL_SCAN_RANGE = 4;
        public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
        private final NapoleonFishEntity animal;
        @Nullable
        private NapoleonFishEntity male;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowMaleNapoleonFishGoal(NapoleonFishEntity pAnimal, double pSpeedModifier) {
            this.animal = pAnimal;
            this.speedModifier = pSpeedModifier;
        }

        public boolean m_8036_() {
            if (this.animal.getGender() == Gender.MALE) {
                return false;
            }
            if (this.male != null && this.male.getGender() == Gender.FEMALE) {
                return false;
            }
            List $$0 = this.animal.m_9236_().m_45976_(((Object)((Object)this.animal)).getClass(), this.animal.m_20191_().m_82377_(8.0, 4.0, 8.0));
            NapoleonFishEntity $$1 = null;
            double $$2 = Double.MAX_VALUE;
            for (NapoleonFishEntity $$3 : $$0) {
                double $$4;
                if ($$3.getGender() != Gender.FEMALE || ($$4 = this.animal.m_20280_((Entity)$$3)) > $$2) continue;
                $$2 = $$4;
                $$1 = $$3;
            }
            if ($$1 == null) {
                return false;
            }
            if ($$2 < 9.0) {
                return false;
            }
            this.male = $$1;
            return true;
        }

        public boolean m_8045_() {
            if (this.animal.getGender() == Gender.MALE) {
                return false;
            }
            if (this.male != null && this.male.getGender() == Gender.FEMALE) {
                return false;
            }
            assert (this.male != null);
            if (!this.male.m_6084_()) {
                return false;
            }
            double $$0 = this.animal.m_20280_((Entity)this.male);
            return !($$0 < 9.0) && !($$0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.male = null;
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.male != null) {
                    this.animal.m_21573_().m_5624_((Entity)this.male, this.speedModifier);
                }
            }
        }
    }
}

