/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.water;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.reaper.vanimals.Vanimals;
import net.reaper.vanimals.client.screen.MudskipperMenu;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.ai.behavior.EntityCategory;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.entity.base.AbstractWaterAnimal;
import net.reaper.vanimals.common.entity.goals.DifferentGenderBreedGoal;
import net.reaper.vanimals.common.enums.Gender;
import net.reaper.vanimals.common.network.OpenMudskipperScreenPacket;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VItems;
import org.jetbrains.annotations.NotNull;

public class MudskipperEntity
extends AbstractWaterAnimal
implements Bucketable,
ContainerListener {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(MudskipperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SEARCHING = SynchedEntityData.m_135353_(MudskipperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ON_MUD = SynchedEntityData.m_135353_(MudskipperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ROLLING = SynchedEntityData.m_135353_(MudskipperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Set<Item> TAME_FOOD = Sets.newHashSet((Object[])new Item[]{(Item)VItems.FOUREYED_FISH_EYE.get()});
    public final AnimationState idlewaterAnimationState = new AnimationState();
    public final AnimationState rollingAnimatonState = new AnimationState();
    public final AnimationState searchingAnimatonState = new AnimationState();
    public final AnimationState dancingAnimatonState = new AnimationState();
    public int idlewaterAnimationTimeout = 0;
    public int searchingAnimationTimeout = 0;
    public int rollingAnimationTimeout = 0;
    public int dancingAnimationTimeout = 0;
    private int fullairSupply = 12000;
    public float currentRoll = 0.0f;
    public float tailRot;
    public float prevTailRot;
    private boolean dancing;
    @Nullable
    private BlockPos jukebox;
    private LazyOptional<?> itemHandler = null;
    public SimpleContainer inventory;

    public MudskipperEntity(EntityType<? extends AbstractAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.f_21342_ = new MudskipperMoveControl(this);
        this.f_21365_ = new LookControl((Mob)this);
        this.f_21344_ = new MudskipperPathNavigation(this, this.m_9236_());
        this.createInventory();
    }

    @Override
    public EntityCategory getCategory() {
        return EntityCategory.AMPHIBIAN;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractAnimal.m_21183_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, (double)0.1f).m_22268_(Attributes.f_22283_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, (double)0.4f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 15));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1f){

            protected boolean m_202729_() {
                return super.m_202729_() && this.f_25684_.m_6162_() && DamageSource.class.desiredAssertionStatus();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, (double)0.9f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_, Items.f_42592_, (ItemLike)VItems.FOUREYED_FISH_EYE.get()}), true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, (double)0.9f));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.1f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new DifferentGenderBreedGoal((Animal)this, 0.9f, MudskipperEntity.class, false));
        this.f_21345_.m_25352_(2, (Goal)new MudskipperRandomStrollGoal(this, 0.2f, 2));
        this.f_21345_.m_25352_(2, (Goal)new MudskipperGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MudskipperGoToLandGoal(this, 1.0));
    }

    @Override
    protected void setupAnimations() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 70;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.idlewaterAnimationTimeout <= 0 && this.m_20069_()) {
            this.idlewaterAnimationTimeout = 40;
            this.idlewaterAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idlewaterAnimationTimeout;
        }
        if (this.dancingAnimationTimeout <= 0 && this.isDancing()) {
            this.dancingAnimationTimeout = 40;
            this.idleAnimationState.m_216973_();
            this.dancingAnimatonState.m_216977_(this.f_19797_);
        } else {
            --this.dancingAnimationTimeout;
        }
        if (this.isSearching()) {
            this.searchingAnimationTimeout = 40;
            this.idleAnimationState.m_216973_();
            this.searchingAnimatonState.m_216977_(this.f_19797_);
        } else {
            --this.searchingAnimationTimeout;
        }
        if (this.isRolling()) {
            this.rollingAnimationTimeout = 40;
            this.idleAnimationState.m_216973_();
            this.rollingAnimatonState.m_216977_(this.f_19797_);
        } else {
            --this.rollingAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (!this.m_20072_()) {
                this.m_6853_(true);
                this.m_20282_(false);
                if (this.m_20146_() < this.fullairSupply / 2) {
                    this.m_7910_(0.3f);
                }
            }
            if (this.m_20072_()) {
                this.m_20282_(true);
                this.m_7910_(0.1f);
            }
            if (this.jukebox == null || !Objects.requireNonNull(this.jukebox).m_203195_((Position)this.m_20182_(), 3.46) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
                this.dancing = false;
                this.jukebox = null;
            }
            if (this.m_21827_()) {
                this.m_21837_(true);
                this.f_20899_ = false;
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                this.f_21344_.m_26573_();
            } else if (!this.m_21827_()) {
                this.m_21837_(false);
                this.f_20899_ = true;
                this.m_21051_(Attributes.f_22279_).m_22100_(0.4);
            }
            if (this.m_146900_().m_60713_(Blocks.f_220864_) && !this.m_20071_()) {
                this.setIsOnMud(true);
            } else if (this.isOnMud() && this.m_20146_() == this.fullairSupply / 2) {
                this.setRolling(true);
            } else if (this.isRolling()) {
                this.m_20301_(this.fullairSupply);
            }
        }
    }

    public void m_6818_(BlockPos pPos, boolean pIsDancing) {
        this.jukebox = pPos;
        this.dancing = pIsDancing;
    }

    public boolean isDancing() {
        return this.dancing;
    }

    public int m_5792_() {
        return 6;
    }

    @Override
    protected DietBuilder createDiet() {
        return new DietBuilder().addFood((ItemLike)Items.f_42591_).addFood((ItemLike)Items.f_42592_);
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else if (this.m_20071_()) {
            this.m_20301_(this.fullairSupply);
        }
    }

    public int m_20146_() {
        return this.fullairSupply;
    }

    @Override
    protected boolean canFlip() {
        return false;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SEARCHING, (Object)false);
        this.f_19804_.m_135372_(ON_MUD, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(ROLLING, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128379_("isSearching", this.isSearching());
        pCompound.m_128379_("isOnMud", this.isOnMud());
        pCompound.m_128379_("isTame", this.m_21824_());
        pCompound.m_128379_("isRolling", this.isRolling());
        ListTag $$1 = new ListTag();
        for (int $$2 = 2; $$2 < this.inventory.m_6643_(); ++$$2) {
            ItemStack $$3 = this.inventory.m_8020_($$2);
            if ($$3.m_41619_()) continue;
            CompoundTag $$4 = new CompoundTag();
            $$4.m_128344_("Slot", (byte)$$2);
            $$3.m_41739_($$4);
            $$1.add((Object)$$4);
        }
        pCompound.m_128379_("Sitting", this.m_21827_());
        pCompound.m_128365_("Items", (Tag)$$1);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setIsSearching(pCompound.m_128471_("isSearching"));
        this.setIsOnMud(pCompound.m_128471_("isOnMud"));
        this.m_7105_(pCompound.m_128471_("isTame"));
        this.setRolling(pCompound.m_128471_("isRolling"));
        this.createInventory();
        ListTag $$1 = pCompound.m_128437_("Items", 10);
        for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
            CompoundTag $$3 = $$1.m_128728_($$2);
            int $$4 = $$3.m_128445_("Slot") & 0xFF;
            if ($$4 < 2 || $$4 >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_($$4, ItemStack.m_41712_((CompoundTag)$$3));
        }
        this.m_21839_(pCompound.m_128471_("Sitting"));
        this.updateContainerEquipment();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12330_;
    }

    public void m_6872_(@NotNull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Age", this.m_146764_());
        tag.m_128359_("Gender", this.getGender().toString());
        tag.m_128379_("isTame", this.m_21824_());
        if (this.m_21805_() != null) {
            tag.m_128362_("Owner", this.m_21805_());
        }
        tag.m_128379_("Inventory", this.hasInventoryChanged((Container)this.inventory));
        ListTag itemList = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack inventoryItem = this.inventory.m_8020_(i);
            if (inventoryItem.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            inventoryItem.m_41739_(itemTag);
            itemList.add((Object)itemTag);
        }
        tag.m_128365_("Items", (Tag)itemList);
    }

    public void m_142278_(@NotNull CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Gender")) {
            this.setGender(Gender.valueOf(tag.m_128461_("Gender").toUpperCase()));
        }
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("isTame")) {
            this.m_7105_(tag.m_128471_("isTame"));
        }
        if (tag.m_128441_("Inventory")) {
            this.setInventory(tag.m_128471_("Inventory"));
        }
        if (tag.m_128441_("Sitting")) {
            this.m_21839_(tag.m_128471_("Sitting"));
        }
        if (tag.m_128403_("Owner")) {
            this.m_21816_(tag.m_128342_("Owner"));
        }
        if (tag.m_128425_("Inventory", 1)) {
            this.setInventory(tag.m_128471_("Inventory"));
        }
        if (tag.m_128425_("Items", 9)) {
            ListTag itemList = tag.m_128437_("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                CompoundTag itemTag = itemList.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                if (slot >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
            }
        }
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)VItems.MUDSKIPPER_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        if (this.m_21824_()) {
            ServerPlayer sp = (ServerPlayer)pPlayer;
            if (sp.f_36096_ != sp.f_36095_) {
                sp.m_6915_();
            }
            sp.m_9217_();
            Vanimals.NETWORK.sendToClient((Player)sp, new OpenMudskipperScreenPacket(sp.f_8940_, this.m_19879_()));
            sp.f_36096_ = new MudskipperMenu(sp.f_8940_, sp.m_150109_(), (Container)this.getInventory(), this);
            sp.m_143399_(sp.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.f_36096_));
        }
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void m_5757_(Container pInvBasic) {
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    @Nullable
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return 4;
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.inventory != pInventory;
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        ItemStack offitemstack = pPlayer.m_21206_();
        if (itemstack.m_150930_(Items.f_220216_) && !this.m_6162_()) {
            this.setIsSearching(false);
            ItemEntity itementity = this.m_20000_((ItemLike)VItems.MUDDY_MELODY_DISC.get(), 1);
            pPlayer.m_5496_(SoundEvents.f_215708_, 0.5f, 1.0f);
            if (itementity != null) {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
        }
        if (!this.m_21824_() && TAME_FOOD.contains(itemstack.m_41720_())) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                    this.m_21828_(pPlayer);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
        } else if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer) && !itemstack.m_150930_(Items.f_42447_) && !offitemstack.m_150930_(Items.f_42447_)) {
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.sendOrderMessage(pPlayer);
                if (pPlayer.m_6047_()) {
                    this.openCustomInventoryScreen(pPlayer);
                }
                if (this.m_21827_()) {
                    this.m_21837_(true);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    protected void sendOrderMessage(Player pPlayer) {
        if (this.m_21827_()) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.vanimals.order.sit")), true);
        } else if (!this.m_21827_()) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.vanimals.order.wander")), true);
        }
    }

    @Override
    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null) {
            this.setGender(Gender.valueOf(dataTag.m_128461_("Gender").toUpperCase()));
            this.m_6863_(dataTag.m_128471_("isBaby"));
            this.m_146762_(dataTag.m_128451_("age"));
            this.m_7105_(dataTag.m_128471_("isTame"));
            this.setInventory(dataTag.m_128471_("Inventory"));
            if (this.m_21805_() != null) {
                dataTag.m_128362_("Owner", this.m_21805_());
            }
            if (dataTag.m_128441_("Sitting")) {
                this.m_21839_(dataTag.m_128471_("Sitting"));
            }
            this.m_27497_(true);
        }
        if (this.canBeBaby() && this.f_19796_.m_188503_(5) == 1) {
            this.m_6863_(true);
        }
        this.setGender((Gender)((Object)Util.m_214670_((Object[])Gender.values(), (RandomSource)RandomSource.m_216327_())));
        assert (spawnDataIn != null);
        return spawnDataIn;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)VEntityTypes.MUDSKIPPER.get()).m_20615_((Level)serverLevel);
    }

    public boolean isSearching() {
        return (Boolean)this.f_19804_.m_135370_(SEARCHING);
    }

    public void setIsSearching(boolean searching) {
        this.f_19804_.m_135381_(SEARCHING, (Object)searching);
    }

    public boolean isOnMud() {
        return (Boolean)this.f_19804_.m_135370_(ON_MUD);
    }

    public void setIsOnMud(boolean isonmud) {
        this.f_19804_.m_135381_(ON_MUD, (Object)isonmud);
    }

    public boolean isRolling() {
        return (Boolean)this.f_19804_.m_135370_(ROLLING);
    }

    public void setRolling(boolean isrolling) {
        this.f_19804_.m_135381_(ROLLING, (Object)isrolling);
    }

    public void setInventory(boolean getInventory) {
        this.getInventory();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new MudskipperPathNavigation(this, pLevel);
    }

    public boolean m_142559_() {
        return super.m_142559_();
    }

    static class MudskipperMoveControl
    extends MoveControl {
        private final MudskipperEntity mudskipper;

        MudskipperMoveControl(MudskipperEntity pMudskipper) {
            super((Mob)pMudskipper);
            this.mudskipper = pMudskipper;
        }

        private void updateSpeed() {
            if (this.mudskipper.m_20069_()) {
                this.mudskipper.m_20256_(this.mudskipper.m_20184_().m_82520_(0.0, -0.005, 0.0));
                if (this.mudskipper.m_6162_()) {
                    this.mudskipper.m_7910_(Math.max(this.mudskipper.m_6113_() / 2.0f, 0.06f));
                }
            } else if (this.mudskipper.m_20096_()) {
                this.mudskipper.m_7910_(Math.max(this.mudskipper.m_6113_() / 2.0f, 0.06f));
            } else if (this.mudskipper.m_21825_()) {
                this.mudskipper.m_7910_(0.0f);
            } else if (this.mudskipper.m_21825_()) {
                this.mudskipper.m_7910_(this.mudskipper.m_6113_());
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mudskipper.m_21573_().m_26571_()) {
                double $$2;
                double $$1;
                double $$0 = this.f_24975_ - this.mudskipper.m_20185_();
                double $$3 = Math.sqrt($$0 * $$0 + ($$1 = this.f_24976_ - this.mudskipper.m_20186_()) * $$1 + ($$2 = this.f_24977_ - this.mudskipper.m_20189_()) * $$2);
                if ($$3 < (double)1.0E-5f) {
                    this.f_24974_.m_7910_(0.0f);
                } else {
                    $$1 /= $$3;
                    float $$4 = (float)(Mth.m_14136_((double)$$2, (double)$$0) * 57.2957763671875) - 90.0f;
                    this.mudskipper.m_146922_(this.m_24991_(this.mudskipper.m_146908_(), $$4, 90.0f));
                    this.mudskipper.f_20883_ = this.mudskipper.m_146908_();
                    float $$5 = (float)(this.f_24978_ * this.mudskipper.m_21133_(Attributes.f_22279_));
                    this.mudskipper.m_7910_(Mth.m_14179_((float)0.125f, (float)this.mudskipper.m_6113_(), (float)$$5));
                    this.mudskipper.m_20256_(this.mudskipper.m_20184_().m_82520_(0.0, (double)this.mudskipper.m_6113_() * $$1 * 0.1, 0.0));
                }
            } else {
                this.mudskipper.m_7910_(0.0f);
            }
        }
    }

    static class MudskipperPathNavigation
    extends AmphibiousPathNavigation {
        MudskipperPathNavigation(MudskipperEntity pMudskipper, Level pLevel) {
            super((Mob)pMudskipper, pLevel);
        }

        public boolean m_6342_(BlockPos pPos) {
            Mob var3 = this.f_26494_;
            if (var3 instanceof MudskipperEntity) {
                MudskipperEntity $$1 = (MudskipperEntity)var3;
                if ($$1.f_267362_.m_267780_()) {
                    return this.f_26495_.m_8055_(pPos).m_60713_(Blocks.f_49990_) || this.f_26495_.m_8055_(pPos).m_60713_(Blocks.f_220864_);
                }
            }
            return !this.f_26495_.m_8055_(pPos.m_7495_()).m_60795_();
        }
    }

    static class MudskipperRandomStrollGoal
    extends RandomStrollGoal {
        private final MudskipperEntity mudskipper;

        MudskipperRandomStrollGoal(MudskipperEntity pMudskipper, double pSpeedModifier, int pInterval) {
            super((PathfinderMob)pMudskipper, pSpeedModifier, pInterval);
            this.mudskipper = pMudskipper;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && super.m_8036_();
        }
    }

    static class MudskipperGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final MudskipperEntity mudskipper;

        MudskipperGoToWaterGoal(MudskipperEntity pMudskipper, double pSpeedModifier) {
            super((PathfinderMob)pMudskipper, pMudskipper.m_6162_() ? 2.0 : pSpeedModifier, 24);
            this.mudskipper = pMudskipper;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.mudskipper.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.mudskipper.m_9236_(), this.f_25602_) && !this.mudskipper.m_21825_() && !this.mudskipper.m_21827_() && !this.mudskipper.isOnMud();
        }

        public boolean m_8036_() {
            if (!(this.mudskipper.m_21827_() || this.mudskipper.m_21825_() || !this.mudskipper.m_6162_() || this.mudskipper.m_20069_() || this.mudskipper.isOnMud())) {
                return super.m_8036_();
            }
            return !this.mudskipper.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_);
        }
    }

    static class MudskipperGoToLandGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 200;
        private final MudskipperEntity mudskipper;

        MudskipperGoToLandGoal(MudskipperEntity pMudskipper, double pSpeedModifier) {
            super((PathfinderMob)pMudskipper, pMudskipper.m_6162_() ? 2.0 : pSpeedModifier, 24);
            this.mudskipper = pMudskipper;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return this.mudskipper.m_20069_() && this.f_25601_ <= 200 && this.m_6465_((LevelReader)this.mudskipper.m_9236_(), this.f_25602_) && !this.mudskipper.m_21825_() && !this.mudskipper.m_21827_() && !this.mudskipper.isOnMud();
        }

        public boolean m_8036_() {
            if (!this.mudskipper.m_21827_() && !this.mudskipper.m_21825_() && this.mudskipper.m_6162_() && this.mudskipper.m_20069_() && !this.mudskipper.isOnMud()) {
                return super.m_8036_();
            }
            return !this.mudskipper.m_20069_() && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_220864_);
        }
    }
}

