/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.ground;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.reaper.vanimals.client.input.InputKey;
import net.reaper.vanimals.client.input.KeyPressType;
import net.reaper.vanimals.client.util.IDynamicCamera;
import net.reaper.vanimals.client.util.IShakeScreenOnStep;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.ai.behavior.EntityCategory;
import net.reaper.vanimals.common.entity.ai.control.RealisticMoveControl;
import net.reaper.vanimals.common.entity.ai.goal.RamAtTargetGoal;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.entity.goals.DifferentGenderBreedGoal;
import net.reaper.vanimals.common.entity.goals.WildBreedGoal;
import net.reaper.vanimals.common.enums.Gender;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VItems;
import net.reaper.vanimals.core.init.VSoundEvents;
import net.reaper.vanimals.util.EntityUtils;
import net.reaper.vanimals.util.compound.CompoundType;
import net.reaper.vanimals.util.compound.EntityData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BisonEntity
extends AbstractAnimal
implements ItemSteerable,
Saddleable,
IDynamicCamera,
IShakeScreenOnStep {
    public static final EntityData<Integer> STUNNED_TICKS = new EntityData<Integer>(BisonEntity.class, "StunnedTicks", CompoundType.INTEGER, 0);
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.m_135353_(BisonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState stunnedAnimationState = new AnimationState();
    private int attackAnimationTimeout = 0;
    private int stunnedAnimationTimeout = 0;
    private final ItemBasedSteering steering = new ItemBasedSteering(this.f_19804_, DATA_BOOST_TIME, DATA_SADDLE_ID);
    private int shieldDamageCounter = 0;

    public BisonEntity(EntityType<? extends AbstractAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.f_21364_ = 20;
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new RealisticMoveControl((Mob)this, 2.0){

            @Override
            public void m_8126_() {
                if (STUNNED_TICKS.get((Entity)BisonEntity.this) <= 0) {
                    super.m_8126_();
                }
            }
        };
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (target = this.m_5448_()) != null && AbstractAnimal.RAM_COOLDOWN.get((Entity)this) <= 0 && this.m_20270_((Entity)target) >= 4.5f) {
            AbstractAnimal.RAM_COOLDOWN.set((Entity)this, 200);
            this.setAttackStrategy(AbstractAnimal.AttackStrategy.RAM);
        }
    }

    @Override
    protected void setupAnimations() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 54;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (STUNNED_TICKS.get((Entity)this) > 0 && this.stunnedAnimationTimeout <= 0 && !this.m_5842_()) {
            this.stunnedAnimationTimeout = 20;
            this.stunnedAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.stunnedAnimationTimeout;
        }
        if (STUNNED_TICKS.get((Entity)this) <= 0 || this.m_5842_()) {
            this.stunnedAnimationState.m_216973_();
        }
        if (this.attackAnimationTimeout == 8) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        }
        if (this.attackAnimationTimeout > 0) {
            --this.attackAnimationTimeout;
        } else {
            this.attackAnimationState.m_216973_();
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Player player;
        ItemStack shield;
        Entity entity;
        if (damageSource.m_7640_() instanceof Projectile && (entity = damageSource.m_7639_()) instanceof Player && (shield = (player = (Player)entity).m_21205_()).m_41720_() instanceof ShieldItem) {
            ++this.shieldDamageCounter;
            if (this.shieldDamageCounter >= 2) {
                shield.m_41774_(1);
                this.shieldDamageCounter = 0;
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected double m_6639_(@NotNull LivingEntity pTarget) {
                double reach = (double)BisonEntity.this.m_20205_() * 1.8;
                return reach * reach + (double)pTarget.m_20205_();
            }

            public boolean m_8036_() {
                return super.m_8036_() && BisonEntity.this.getAttackStrategy() == AbstractAnimal.AttackStrategy.MELEE && !this.f_25540_.m_6162_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && BisonEntity.this.getAttackStrategy() == AbstractAnimal.AttackStrategy.MELEE && !this.f_25540_.m_6162_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new RamAtTargetGoal(this, 0.3f));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> this.m_20072_() && !this.m_6162_(), 300));
        this.f_21345_.m_25352_(1, (Goal)new DifferentGenderBreedGoal((Animal)this, 0.9f));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.1f){

            protected boolean m_202729_() {
                return super.m_202729_() && this.f_25684_.m_6162_() && DamageSource.class.desiredAssertionStatus();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, (double)0.9f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42405_, (ItemLike)VItems.APPLE_ON_A_STICK.get()}), false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, (double)0.9f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.9f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22283_, 0.1).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return this.m_6162_() ? pDimensions.f_20378_ * 0.95f : 1.3f;
    }

    @Override
    public EntityCategory getCategory() {
        return EntityCategory.GROUND;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)VEntityTypes.BISON.get()).m_20615_((Level)pLevel);
    }

    @Override
    protected DietBuilder createDiet() {
        return new DietBuilder().addFood((ItemLike)Items.f_42410_).addFood((ItemLike)Items.f_42405_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188503_(2) == 0 ? (SoundEvent)VSoundEvents.BISON_IDLE.get() : (SoundEvent)VSoundEvents.BISON_IDLE2.get();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (itemInHand.m_150930_(Items.f_42446_) && !this.m_6162_() && this.getGender() == Gender.FEMALE) {
            pPlayer.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)itemInHand, (Player)pPlayer, (ItemStack)Items.f_42455_.m_7968_()));
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemInHand.m_150930_(Items.f_42574_) && !this.m_6162_() && this.getGender() == Gender.MALE) {
            ItemEntity itementity = this.m_20000_((ItemLike)VItems.BISON_FUR.get(), 2);
            pPlayer.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            if (itementity != null) {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
        }
        if (!this.m_6898_(itemInHand) && this.m_6254_() && !this.m_20160_() && !pPlayer.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                this.startRiding((LivingEntity)pPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult result = super.m_6071_(pPlayer, pHand);
        if (!result.m_19077_() && itemInHand.m_150930_(Items.f_42450_)) {
            return itemInHand.m_41647_(pPlayer, (LivingEntity)this, pHand);
        }
        return result.m_19077_() ? result : InteractionResult.PASS;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Player player;
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player && EntityUtils.checkItemsInHands((LivingEntity)(player = (Player)entity), item -> item == VItems.APPLE_ON_A_STICK.get())) {
            return player;
        }
        return null;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pDataAccessor) {
        if (DATA_SADDLE_ID.equals(pDataAccessor) && this.m_9236_().f_46443_) {
            this.steering.m_20844_();
        }
        super.m_7350_(pDataAccessor);
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_BOOST_TIME, (Object)0);
        STUNNED_TICKS.define((Entity)this);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.steering.m_20847_(pCompound);
        STUNNED_TICKS.write((Entity)this, pCompound);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.steering.m_20852_(pCompound);
        STUNNED_TICKS.read((Entity)this, pCompound);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    public void m_5853_(@Nullable SoundSource pSoundSource) {
        this.steering.m_20849_(true);
        if (pSoundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12034_, pSoundSource, 0.5f, 1.0f);
        }
    }

    @Override
    protected float[] getInputSpeed(@NotNull Player pPlayer) {
        return new float[]{0.0f, 0.0f, this.m_20142_() ? 0.8f : 0.3f};
    }

    public double m_6048_() {
        return super.m_6048_() + (double)0.3f;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return this.f_19796_.m_188503_(2) == 0 ? (SoundEvent)VSoundEvents.BISON_HURT.get() : (SoundEvent)VSoundEvents.BISON_HURT2.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.f_19796_.m_188503_(2) == 0 ? (SoundEvent)VSoundEvents.BISON_DEATH.get() : (SoundEvent)VSoundEvents.BISON_DEATH2.get();
    }

    protected void m_267689_(float pPartialTick) {
        float speed = this.m_6688_() != null ? 2.2f : (!this.m_6162_() ? 8.5f : 4.5f);
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * speed, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public boolean m_6746_() {
        return true;
    }

    @Override
    public boolean isRideable() {
        return !this.m_6162_();
    }

    public void m_7822_(byte pId) {
        switch (pId) {
            case 4: {
                if (this.attackAnimationTimeout <= 0) {
                    this.attackAnimationTimeout = 8;
                }
                this.m_5496_((SoundEvent)VSoundEvents.BISON_ATTACK.get(), 1.0f, 1.0f);
                break;
            }
            case 39: {
                STUNNED_TICKS.set((Entity)this, 50);
                break;
            }
            default: {
                super.m_7822_(pId);
            }
        }
    }

    @Override
    public boolean canBreakBlockNearby() {
        return true;
    }

    @Override
    public boolean isValidBlockForBreak(BlockState pBlockState) {
        return pBlockState.m_60734_() instanceof LeavesBlock;
    }

    public boolean m_6094_() {
        if (STUNNED_TICKS.get((Entity)this) <= 0 || !this.m_5912_()) {
            super.m_6094_();
        }
        return true;
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.m_6162_() && !this.m_5912_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && !this.m_6162_()) {
            if (STUNNED_TICKS.get((Entity)this) > 0) {
                STUNNED_TICKS.set((Entity)this, STUNNED_TICKS.get((Entity)this) - 1);
                this.stunEffect();
                this.m_7910_(0.0f);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                this.f_21344_.m_26573_();
                if (STUNNED_TICKS.get((Entity)this) == 1) {
                    this.m_5496_((SoundEvent)VSoundEvents.BISON_ROAR.get(), 1.0f, 1.0f);
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.15);
                }
            }
            if (this.m_6162_()) {
                this.m_7910_(0.2f);
                this.m_21153_(0.25f);
            }
            if (this.m_5912_()) {
                this.m_7910_(0.2f);
            }
            if (this.m_5448_() != null) {
                this.m_6858_(true);
                this.m_7910_(0.2f);
            }
        }
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || STUNNED_TICKS.get((Entity)this) > 0;
    }

    public boolean m_142582_(@NotNull Entity pEntity) {
        return STUNNED_TICKS.get((Entity)this) <= 0 && super.m_142582_(pEntity);
    }

    public boolean m_7327_(@NotNull Entity pTarget) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = this.getAttackDamage();
        float damage = attackDamage > 0.0f ? attackDamage / 2.0f + (float)this.f_19796_.m_188503_((int)attackDamage) : attackDamage;
        boolean hurt = pTarget.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
        if (hurt) {
            double knockbackResistance = 0.0;
            if (pTarget instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pTarget;
                knockbackResistance = living.m_21133_(Attributes.f_22278_);
            }
            double knockbackFactor = Math.max(0.0, 1.0 - knockbackResistance);
            pTarget.m_20256_(pTarget.m_20184_().m_82520_(0.0, 0.1 * knockbackFactor, 0.0));
            this.m_19970_((LivingEntity)this, pTarget);
        }
        if (this.getAttackStrategy() == AbstractAnimal.AttackStrategy.RAM) {
            this.knockBack(pTarget);
        }
        if (this.m_217043_().m_188501_() < 0.5f) {
            this.cooldownShield(pTarget, 60);
        }
        this.m_5496_((SoundEvent)VSoundEvents.BISON_ATTACK_2.get(), 1.0f, 1.0f);
        return hurt;
    }

    private void stunEffect() {
        if (this.f_19796_.m_188503_(6) == 0) {
            double d0 = this.m_20185_() - (double)this.m_20205_() * Math.sin(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            double d1 = this.m_20186_() + (double)this.m_20206_() - 0.3;
            double d2 = this.m_20189_() + (double)this.m_20205_() * Math.cos(this.f_20883_ * ((float)Math.PI / 180)) + (this.f_19796_.m_188500_() * 0.6 - 0.3);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    protected void m_6731_(@NotNull LivingEntity pEntity) {
        if (this.f_19796_.m_188500_() < 0.5) {
            this.m_5496_((SoundEvent)VSoundEvents.BISON_ATTACK_2.get(), 1.0f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            pEntity.m_7334_((Entity)this);
        }
        pEntity.f_19864_ = true;
    }

    public void knockBack(@Nullable Entity pEntity) {
        if (pEntity == null) {
            return;
        }
        double yRot = Math.toRadians(this.m_146908_());
        double dirX = -Math.sin(yRot);
        double dirZ = Math.cos(yRot);
        Vec3 vec3 = new Vec3(dirX, 0.0, dirZ).m_82541_().m_82490_((double)2.1f);
        pEntity.m_20334_(vec3.f_82479_, (double)0.9f, vec3.f_82481_);
    }

    @Override
    public void onServerInput(InputKey pInputKey, KeyPressType pKeyPressType) {
        if (pKeyPressType == KeyPressType.HOLD && pInputKey == InputKey.CTRL) {
            this.attackEntitiesInFront(0.25f, 0.6f, this::knockBack);
            Vec3 headPosition = this.m_20182_().m_82520_(0.0, (double)this.m_20192_(), 0.0);
            Vec3 lookDirection = this.m_20154_().m_82541_();
            Vec3 headWithOffset = headPosition.m_82549_(lookDirection.m_82490_(3.5));
            float yaw = this.m_146908_();
            float pitch = this.m_146909_();
            Vec3 direction = new Vec3(-Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)), -Math.sin(Math.toRadians(pitch)), Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch))).m_82541_();
            if (pitch > 30.0f) {
                Vec3 targetPosition = headWithOffset.m_82549_(direction.m_82490_((double)2.8f));
                BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(headWithOffset, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos targetPos = hitResult.m_82425_();
                    BlockState targetBlockState = this.m_9236_().m_8055_(targetPos);
                    if (targetBlockState.m_60713_(Blocks.f_50493_) || targetBlockState.m_60713_(Blocks.f_50440_)) {
                        this.m_9236_().m_245803_((Entity)this, targetPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 0.7f);
                        this.m_9236_().m_7731_(targetPos, Blocks.f_50093_.m_49966_(), 3);
                    }
                }
            }
        }
    }

    @Override
    public float getMaxCameraTilt() {
        return 10.0f;
    }

    @Override
    public float getCameraTiltSpeed() {
        return 3.0f;
    }

    @Override
    public boolean canEntityShake(@NotNull LivingEntity pEntity) {
        boolean stepping = EntityUtils.isEntityStepping((LivingEntity)this, this.getShakeFrequency(), !this.m_20142_() ? 0.2f : 0.3f);
        return IShakeScreenOnStep.super.canEntityShake(pEntity) && !this.m_6162_() && EntityUtils.isEntityMoving((Entity)this, 0.04f) && stepping;
    }

    @Override
    public float getShakePower() {
        return !this.m_20142_() ? 0.07f : 0.16f;
    }

    @Override
    public float getShakeFrequency() {
        return !this.m_20142_() ? 0.6f : 1.3f;
    }

    @Override
    public float getShakeDistance() {
        return !this.m_20142_() ? 10.0f : 15.0f;
    }
}

