/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.goals;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.entity.base.AbstractWaterAnimal;
import net.reaper.vanimals.common.enums.Gender;

public class WildBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final Level level;
    @Nullable
    protected Animal partner;
    protected final Predicate<Animal> predicate;
    int chance;

    public WildBreedGoal(Animal pAnimal, Predicate<Animal> predicate) {
        this(pAnimal, pAnimal.getClass(), predicate, 200);
    }

    public WildBreedGoal(Animal pAnimal, Predicate<Animal> predicate, int chanceToUse) {
        this(pAnimal, pAnimal.getClass(), predicate, chanceToUse);
    }

    public WildBreedGoal(Animal animal, Class<? extends Animal> partnerClass, Predicate<Animal> predicate) {
        this(animal, partnerClass, predicate, 200);
    }

    public WildBreedGoal(Animal animal, Class<? extends Animal> partnerClass, Predicate<Animal> predicate, int chanceToUse) {
        this.animal = animal;
        this.level = animal.m_9236_();
        this.partnerClass = partnerClass;
        this.predicate = predicate;
        this.chance = chanceToUse;
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.partner != null) {
            this.animal.m_27595_(null);
            this.partner.m_27595_(null);
        }
    }

    public boolean m_8036_() {
        if (this.predicate.test(this.animal) && this.animal.m_217043_().m_188503_(this.chance) == 0) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null && this.partner.m_146764_() == 0 && this.animal.m_146764_() == 0;
    }

    private boolean canMateWith(Animal pAnimal, Animal pOtherAnimal) {
        AbstractAnimal animal;
        if (pOtherAnimal == pAnimal) {
            return false;
        }
        if (pOtherAnimal.getClass() != pAnimal.getClass()) {
            return false;
        }
        if (pAnimal instanceof AbstractWaterAnimal) {
            animal = (AbstractWaterAnimal)pAnimal;
            if (pOtherAnimal instanceof AbstractWaterAnimal) {
                AbstractWaterAnimal otherAnimal = (AbstractWaterAnimal)pOtherAnimal;
                return pAnimal.m_5957_() && pOtherAnimal.m_5957_() && (animal.getGender() == Gender.MALE && otherAnimal.getGender() == Gender.FEMALE || animal.getGender() == Gender.FEMALE && otherAnimal.getGender() == Gender.MALE);
            }
        }
        if (pAnimal instanceof AbstractAnimal) {
            animal = (AbstractAnimal)pAnimal;
            if (pOtherAnimal instanceof AbstractAnimal) {
                AbstractAnimal otherAnimal = (AbstractAnimal)pOtherAnimal;
                return pAnimal.m_5957_() && pOtherAnimal.m_5957_() && (animal.getGender() == Gender.MALE && otherAnimal.getGender() == Gender.FEMALE || animal.getGender() == Gender.FEMALE && otherAnimal.getGender() == Gender.MALE);
            }
        }
        return false;
    }

    private Animal getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Animal animal = null;
        for (Animal target : list) {
            if (!this.canMateWith(this.animal, target) || !(this.animal.m_20280_((Entity)target) < d0)) continue;
            animal = target;
            d0 = this.animal.m_20280_((Entity)target);
        }
        return animal;
    }
}

