/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.goals;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.reaper.vanimals.Vanimals;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.enums.Gender;

public class DifferentGenderBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final Level level;
    @Nullable
    protected Animal partner;
    private int loveTime;
    private final double speedModifier;
    private boolean eggBreeding = false;

    public DifferentGenderBreedGoal(Animal pAnimal, double pSpeedModifier) {
        this(pAnimal, pSpeedModifier, pAnimal.getClass());
    }

    public DifferentGenderBreedGoal(Animal pAnimal, double pSpeedModifier, Class<? extends Animal> pPartnerClass) {
        this.animal = pAnimal;
        this.level = pAnimal.m_9236_();
        this.partnerClass = pPartnerClass;
        this.speedModifier = pSpeedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public DifferentGenderBreedGoal(Animal pAnimal, double pSpeedModifier, Class<? extends Animal> pPartnerClass, boolean doesLayEggs) {
        this.animal = pAnimal;
        this.level = pAnimal.m_9236_();
        this.partnerClass = pPartnerClass;
        this.speedModifier = pSpeedModifier;
        this.eggBreeding = doesLayEggs;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.animal.m_6162_()) {
            return false;
        }
        if (this.animal.m_146764_() > 0) {
            return false;
        }
        if (!this.animal.m_27593_()) {
            this.animal.m_146762_(0);
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean m_8045_() {
        return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 60;
    }

    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
        this.animal.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 9.0) {
            AbstractAnimal animal;
            AbstractAnimal partner;
            Animal animal2;
            if (this.eggBreeding) {
                animal2 = this.partner;
                if (animal2 instanceof AbstractAnimal) {
                    partner = (AbstractAnimal)animal2;
                    animal2 = this.animal;
                    if (animal2 instanceof AbstractAnimal) {
                        animal = (AbstractAnimal)animal2;
                        if (animal.getGender() == Gender.MALE) {
                            partner.setHasEggs(true);
                        } else {
                            animal.setHasEggs(true);
                        }
                    }
                }
            } else {
                this.breed();
            }
            animal2 = this.partner;
            if (animal2 instanceof AbstractAnimal) {
                partner = (AbstractAnimal)animal2;
                animal2 = this.animal;
                if (animal2 instanceof AbstractAnimal) {
                    animal = (AbstractAnimal)animal2;
                    animal.m_146762_(animal.EGG_LAYING_COOLDOWN);
                    animal.m_27594_();
                    if (this.partner != null) {
                        this.partner.m_146762_(animal.EGG_LAYING_COOLDOWN);
                        this.partner.m_27594_();
                    }
                }
            }
            RandomSource randomsource = this.animal.m_217043_();
            if (this.level.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.level.m_7967_((Entity)new ExperienceOrb(this.level, this.animal.m_20185_(), this.animal.m_20186_(), this.animal.m_20189_(), randomsource.m_188503_(7) + 1));
            }
        }
    }

    @Nullable
    protected Animal getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(8.0));
        double d0 = Double.MAX_VALUE;
        Animal chosenPartner = null;
        Vanimals.LOGGER.info("GET FREE PARTNER");
        for (Animal potentialPartner : list) {
            Vanimals.LOGGER.info("potential partner");
            if (!this.animal.m_7848_(potentialPartner) || !this.isValidPair(this.animal, potentialPartner) || !(this.animal.m_20280_((Entity)potentialPartner) < d0)) continue;
            Vanimals.LOGGER.info("canMatee");
            chosenPartner = potentialPartner;
            d0 = this.animal.m_20280_((Entity)potentialPartner);
        }
        return chosenPartner;
    }

    private boolean isValidPair(Animal animal1, Animal animal2) {
        if (!(animal1 instanceof AbstractAnimal) || !(animal2 instanceof AbstractAnimal)) {
            return false;
        }
        AbstractAnimal customAnimal1 = (AbstractAnimal)animal1;
        AbstractAnimal customAnimal2 = (AbstractAnimal)animal2;
        return customAnimal1.getGender() != customAnimal2.getGender();
    }

    protected void breed() {
        this.animal.m_27563_((ServerLevel)this.level, this.partner);
    }
}

