/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.base;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.reaper.vanimals.client.input.InputKey;
import net.reaper.vanimals.client.input.InputStateManager;
import net.reaper.vanimals.client.input.KeyPressType;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.ai.behavior.EntityCategory;
import net.reaper.vanimals.common.entity.ai.control.RealisticMoveControl;
import net.reaper.vanimals.common.entity.ai.navigation.SmartGroundNavigation;
import net.reaper.vanimals.common.enums.Gender;
import net.reaper.vanimals.core.init.VEntityData;
import net.reaper.vanimals.util.EntityUtils;
import net.reaper.vanimals.util.ParticleEffectBuilder;
import net.reaper.vanimals.util.TickUtils;
import net.reaper.vanimals.util.compound.CompoundType;
import net.reaper.vanimals.util.compound.EntityData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnimal
extends TamableAnimal {
    public static final EntityData<Integer> ATTACK_STRATEGY = new EntityData<Integer>(AbstractAnimal.class, "AttackStrategy", CompoundType.INTEGER, 0);
    public static final EntityData<Integer> RAM_COOLDOWN = new EntityData<Integer>(AbstractAnimal.class, "RunCooldown", CompoundType.INTEGER, 0);
    private static final EntityDataAccessor<Gender> GENDER = SynchedEntityData.m_135353_(AbstractAnimal.class, (EntityDataSerializer)((EntityDataSerializer)VEntityData.GENDER.get()));
    private static final EntityDataAccessor<Boolean> HAS_EGGS = SynchedEntityData.m_135353_(AbstractAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final DietBuilder diet;
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public EntityCategory category = this.getCategory();
    public final int EGG_LAYING_COOLDOWN = 6000;

    public AbstractAnimal(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.diet = this.createDiet();
        this.setAttackStrategy(AttackStrategy.MELEE);
        this.f_21342_ = new RealisticMoveControl((Mob)this, this.getBodyRotateSpeed());
        this.f_21344_ = new SmartGroundNavigation((Mob)this, this.getNavigationAccuracy());
    }

    public abstract EntityCategory getCategory();

    protected float getBodyRotateSpeed() {
        return 2.0f;
    }

    protected float getNavigationAccuracy() {
        return 1.0f;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public DietBuilder getDiet() {
        return this.diet;
    }

    protected abstract DietBuilder createDiet();

    protected void setupAnimations() {
    }

    @NotNull
    protected ParticleEffectBuilder getParticleEffectBuilder() {
        return new ParticleEffectBuilder(this.m_9236_(), (Entity)this);
    }

    public Gender getGender() {
        return (Gender)((Object)this.f_19804_.m_135370_(GENDER));
    }

    public void setGender(Gender gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GENDER, (Object)Gender.MALE);
        this.f_19804_.m_135372_(HAS_EGGS, (Object)false);
        ATTACK_STRATEGY.define((Entity)this);
        RAM_COOLDOWN.define((Entity)this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ATTACK_STRATEGY.write((Entity)this, pCompound);
        RAM_COOLDOWN.write((Entity)this, pCompound);
        pCompound.m_128379_("HasEggs", this.doesHaveEggs());
        pCompound.m_128359_("Gender", this.getGender().toString());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ATTACK_STRATEGY.read((Entity)this, pCompound);
        RAM_COOLDOWN.read((Entity)this, pCompound);
        this.setGender(Gender.valueOf(pCompound.m_128461_("Gender").toUpperCase()));
        this.setHasEggs(pCompound.m_128471_("HasEggs"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimations();
            if (this.canSprintByPlayer() && this.m_146895_() != null) {
                if (InputStateManager.getInstance().isKeyPress(InputKey.CTRL, KeyPressType.HOLD)) {
                    if (EntityUtils.isEntityMoving((Entity)this, 0.08f)) {
                        if (this.category == EntityCategory.GROUND) {
                            BlockPos blockPos = this.m_20097_();
                            BlockState blockState = this.m_9236_().m_8055_(blockPos);
                            TickUtils.doEvery((Entity)this, 4, () -> {
                                for (float angle : new float[]{-0.3f, 0.3f}) {
                                    if (blockState.addRunningEffects(this.m_9236_(), blockPos, (Entity)this) || blockState.m_60799_() == RenderShape.INVISIBLE) continue;
                                    Vec3 delta = this.m_20184_();
                                    Vec3 lookAngle = this.m_20154_().m_82541_();
                                    Vec3 sideOffset = new Vec3(-lookAngle.f_82481_, 0.0, lookAngle.f_82479_ + (double)0.6f).m_82541_().m_82490_((double)angle);
                                    double particleX = this.m_20185_() + sideOffset.f_82479_;
                                    double particleZ = this.m_20189_() + sideOffset.f_82481_;
                                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, particleX, this.m_20186_() + (double)0.3f, particleZ, delta.f_82479_ / 2.5, (double)0.01f, delta.f_82481_ / 2.5);
                                }
                            });
                        }
                        this.m_6858_(true);
                    } else {
                        this.m_6858_(false);
                    }
                } else {
                    this.m_6858_(false);
                }
            }
        } else {
            RAM_COOLDOWN.set((Entity)this, Math.max(RAM_COOLDOWN.get((Entity)this) - 1, 0));
        }
    }

    public boolean canBreakBlockNearby() {
        return false;
    }

    public float getBlockBreakRadius() {
        return 0.2f;
    }

    public boolean isValidBlockForBreak(BlockState pBlockState) {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.canBreakBlockNearby() && this.m_6084_() && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean destroyedBlock = false;
            AABB boundingBox = this.m_20191_().m_82400_((double)this.getBlockBreakRadius());
            int minX = Mth.m_14107_((double)boundingBox.f_82288_);
            int minY = Mth.m_14107_((double)boundingBox.f_82289_);
            int minZ = Mth.m_14107_((double)boundingBox.f_82290_);
            int maxX = Mth.m_14107_((double)boundingBox.f_82291_);
            int maxY = Mth.m_14107_((double)boundingBox.f_82292_);
            int maxZ = Mth.m_14107_((double)boundingBox.f_82293_);
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                BlockState state = this.m_9236_().m_8055_(pos);
                if (!this.isValidBlockForBreak(state)) continue;
                destroyedBlock = this.m_9236_().m_46953_(pos, true, (Entity)this) || destroyedBlock;
            }
            if (!destroyedBlock && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    public boolean m_6898_(@NotNull ItemStack pItemStack) {
        return this.getDiet().isFoodInDiet((ItemLike)pItemStack.m_41720_());
    }

    public void onServerInput(InputKey pInputKey, KeyPressType pKeyPressType) {
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity pPassenger) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_().m_122479_()) {
            int[][] offsets = DismountHelper.m_38467_((Direction)direction);
            for (Pose pose : pPassenger.m_7431_()) {
                for (int[] offset : offsets) {
                    BlockPos targetPos = this.m_20183_().m_7918_(offset[0], 0, offset[1]);
                    double floorHeight = this.m_9236_().m_45573_(targetPos);
                    if (!DismountHelper.m_38439_((double)floorHeight)) continue;
                    Vec3 dismountPos = Vec3.m_82514_((Vec3i)targetPos, (double)floorHeight);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pPassenger, (AABB)pPassenger.m_21270_(pose).m_82383_(dismountPos))) continue;
                    pPassenger.m_20124_(pose);
                    return dismountPos;
                }
            }
        }
        return super.m_7688_(pPassenger);
    }

    protected void m_19956_(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.m_20365_(pPassenger)) {
            pCallback.m_20372_(pPassenger, this.m_20185_(), this.m_20186_() + this.m_6048_(), this.m_20189_());
        } else {
            super.m_19956_(pPassenger, pCallback);
        }
    }

    @Contract(value="null->false")
    public boolean startRiding(@Nullable LivingEntity pEntity) {
        if (pEntity != null) {
            pEntity.m_146922_(this.m_146908_());
            pEntity.m_146926_(this.m_146909_());
            pEntity.m_5616_(this.m_6080_());
            pEntity.m_20329_((Entity)this);
            return true;
        }
        return false;
    }

    @Contract(value="null->false")
    public boolean canAddPassenger(@Nullable LivingEntity pEntity) {
        if (pEntity == null) {
            return false;
        }
        return !this.m_6162_() && this.canAddPassenger(pEntity);
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.m_6162_() && this.m_146764_() <= 0 && !this.doesHaveEggs();
    }

    public boolean doesHaveEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGGS);
    }

    public void setHasEggs(boolean hasEggs) {
        this.f_19804_.m_135381_(HAS_EGGS, (Object)hasEggs);
    }

    public boolean isRideable() {
        return false;
    }

    protected float[] getInputSpeed(@NotNull Player pPlayer) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.isRideable() && this.m_20160_()) {
            float[] speed = this.getInputSpeed(pPlayer);
            return new Vec3((double)speed[0], (double)speed[1], (double)speed[2]);
        }
        return Vec3.f_82478_;
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        if (this.isRideable()) {
            this.m_19915_(pPlayer.m_146908_(), pPlayer.m_146909_() * 0.5f);
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            this.f_19859_ = this.m_146908_();
        }
    }

    public boolean canSprintByPlayer() {
        return true;
    }

    public void cooldownShield(@Nullable Entity pEntity, int pCooldown) {
        Player player;
        Item item;
        if (pEntity instanceof Player && (item = (player = (Player)pEntity).m_21211_().m_41720_()) == Items.f_42740_) {
            player.m_5810_();
            InteractionHand hand = player.m_7655_();
            player.m_21211_().m_41622_(1, (LivingEntity)player, player1 -> {
                player.m_21190_(hand);
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)player.m_21211_(), (InteractionHand)hand);
            });
            ItemCooldowns cooldowns = player.m_36335_();
            if (!cooldowns.m_41519_(item)) {
                cooldowns.m_41524_(item, pCooldown);
            }
            player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
        }
    }

    public void attackEntitiesInFront(float pDistance, float pRadius, Consumer<LivingEntity> pTarget) {
        Vec3 lookAngle = this.m_20154_().m_82541_();
        Vec3 start = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(start.m_82520_((double)(-pRadius), (double)(-pRadius), (double)(-pRadius)), start.m_82520_((double)pRadius, (double)pDistance, (double)pRadius)));
        for (LivingEntity entity : entities) {
            Vec3 directionToEntity;
            double dotProduct;
            double angle;
            if (entity == this || !entity.m_6084_() || !((angle = Math.acos(dotProduct = lookAngle.m_82526_(directionToEntity = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(start).m_82541_()))) <= 1.5707963267948966)) continue;
            pTarget.accept(entity);
            this.m_7327_((Entity)entity);
        }
    }

    public AttackStrategy getAttackStrategy() {
        return AttackStrategy.values()[ATTACK_STRATEGY.get((Entity)this)];
    }

    public void setAttackStrategy(AttackStrategy pAttackStrategy) {
        ATTACK_STRATEGY.set((Entity)this, pAttackStrategy.ordinal());
    }

    public boolean canBeBaby() {
        return true;
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (this.canBeBaby() && this.f_19796_.m_188503_(5) == 1) {
            this.m_6863_(true);
        }
        this.setGender((Gender)((Object)Util.m_214670_((Object[])Gender.values(), (RandomSource)RandomSource.m_216327_())));
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public static enum AttackStrategy {
        MELEE,
        RAM;

    }
}

