/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;

public class RamAtTargetGoal
extends Goal {
    protected final AbstractAnimal animal;
    private final float speedModifier;
    protected float reachDistance = 0.2f;
    protected Vec3 direction;
    private int runTicks;
    private boolean reached;

    public RamAtTargetGoal(AbstractAnimal pAnimal, float pSpeedModifier) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.animal = pAnimal;
        this.speedModifier = pSpeedModifier;
    }

    public RamAtTargetGoal setReachDistance(float pReachDistance) {
        this.reachDistance = pReachDistance;
        return this;
    }

    private boolean isSafePath(BlockPos pBlockPos) {
        BlockState blockState = this.animal.m_9236_().m_8055_(pBlockPos.m_7495_());
        return !blockState.m_60795_() && !blockState.m_60713_(Blocks.f_49990_);
    }

    public boolean m_8036_() {
        LivingEntity target = this.animal.m_5448_();
        if (!this.animal.m_6162_() && this.animal.getAttackStrategy() != AbstractAnimal.AttackStrategy.RAM) {
            return false;
        }
        return target != null && target.m_6084_();
    }

    public void m_8056_() {
        super.m_8056_();
        LivingEntity target = this.animal.m_5448_();
        if (target != null && !this.animal.m_6162_()) {
            this.direction = target.m_20182_().m_82546_(this.animal.m_20182_()).m_82541_();
            this.runTicks = 65;
        }
        this.reached = false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.animal.m_5448_();
        if (target != null && !this.animal.m_6162_()) {
            --this.runTicks;
            this.animal.m_6858_(true);
            if (!this.animal.m_9236_().m_5776_()) {
                this.animal.attackEntitiesInFront(0.35f, 1.3f, entity -> {
                    this.runTicks = 0;
                });
            }
            if (this.direction != null) {
                BlockPos nextPos = this.animal.m_20183_().m_7918_((int)Math.round(this.direction.f_82479_), 0, (int)Math.round(this.direction.f_82481_));
                if (!this.isSafePath(nextPos)) {
                    this.runTicks = 0;
                    return;
                }
                double angle = Math.atan2(this.direction.f_82481_, this.direction.f_82479_);
                this.animal.m_146922_((float)Math.toDegrees(angle) - 90.0f);
                this.animal.m_20334_(this.direction.f_82479_ * (double)this.speedModifier, this.animal.m_20184_().f_82480_, this.direction.f_82481_ * (double)this.speedModifier);
            }
        }
    }

    public boolean m_8045_() {
        return this.animal.m_5448_() != null && !this.animal.m_6162_() && this.runTicks > 0;
    }

    public void m_8041_() {
        super.m_8041_();
        this.animal.setAttackStrategy(AbstractAnimal.AttackStrategy.MELEE);
        this.animal.m_6858_(false);
    }
}

