/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.vanimals.mixin.access.CameraAccessor;

@Mod.EventBusSubscriber(modid="vanimals", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class PlayerScreenShaker {
    public static double shakeTicks = 0.0;
    public static double shakePower = 0.0;

    public static void startShake(int pDuration, float pShakePower) {
        shakeTicks = pDuration;
        shakePower = Math.min(pShakePower, 5.0f);
    }

    @SubscribeEvent
    public static void onUpdateScreenShaker(TickEvent.ClientTickEvent pEvent) {
        if (pEvent.phase == TickEvent.Phase.START && !Minecraft.m_91087_().m_91104_()) {
            if (shakeTicks > 0.0) {
                shakeTicks -= 5.0;
            } else {
                shakePower = 0.0;
            }
        }
    }

    @SubscribeEvent
    public static void onUpdateCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_() && shakeTicks > 0.0) {
            double intensity = shakePower * (Double)Minecraft.m_91087_().f_91066_.m_231924_().m_231551_();
            double maxShakeTicks = 20.0;
            double damping = Math.max(0.0, shakeTicks / maxShakeTicks);
            double amplitude = intensity * damping;
            double frequency = 1.0;
            double offsetX = amplitude * Math.sin((double)player.f_19797_ * frequency + player.m_217043_().m_188500_() * Math.PI);
            double offsetY = amplitude * Math.cos((double)player.f_19797_ * frequency + player.m_217043_().m_188500_() * Math.PI * 0.5);
            double offsetZ = amplitude * Math.sin((double)player.f_19797_ * frequency + player.m_217043_().m_188500_() * Math.PI * 0.25);
            ((CameraAccessor)event.getCamera()).callMove(offsetX, offsetY, offsetZ);
        }
    }
}

