/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.model.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.reaper.vanimals.client.animations.entity.FourEyedFishAnimations;
import net.reaper.vanimals.common.entity.water.FoureyedFishEntity;
import org.jetbrains.annotations.NotNull;

public class FourEyedFishModel
extends HierarchicalModel<FoureyedFishEntity> {
    private final ModelPart root;
    private final ModelPart foureyed;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart tail2;

    public FourEyedFishModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.foureyed = this.root.m_171324_("foureyed");
        this.body = this.foureyed.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.tail2 = this.tail.m_171324_("tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition foureyed = root.m_171599_("foureyed", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = foureyed.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 0.1667f, -2.5f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(0.5f, -0.8333f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(14, 18).m_171488_(-1.5f, -0.8333f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.1667f, (float)-4.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, 0.05f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(18, 9).m_171488_(0.0f, -2.0f, 3.05f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.1667f, (float)4.45f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -2.0f, -1.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.05f));
        PartDefinition fin = body.m_171599_("fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)0.6667f, (float)1.5f));
        PartDefinition cube_r1 = fin.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171488_(0.0f, -0.5f, 0.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition fin2 = body.m_171599_("fin2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)0.6667f, (float)1.5f));
        PartDefinition cube_r2 = fin2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171488_(0.0f, -0.5f, 0.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private void dynamicTail(@NotNull FoureyedFishEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.tail.f_104204_, (float)targetYaw);
        this.tail2.f_104204_ = Mth.m_14179_((float)0.04f, (float)this.tail2.f_104204_, (float)targetYaw);
    }

    protected void applyBodyAndHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-360.0f, (float)360.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-360.0f, (float)360.0f);
        this.root.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.root.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
    }

    public void setupAnim(@NotNull FoureyedFishEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.dynamicTail(pEntity);
        this.applyBodyAndHeadRotation(pNetHeadYaw, pHeadPitch);
        if (!pEntity.m_20072_()) {
            this.m_233381_(pEntity.flipAnimationState, FourEyedFishAnimations.FLOP, pAgeInTicks);
        }
        this.m_267799_(FourEyedFishAnimations.SWIM, pLimbSwing, pLimbSwingAmount, 3.0f, 1.0f);
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (pEntity.m_146908_() - pEntity.f_19859_) * 0.1f));
        pEntity.currentRoll += (targetRoll - pEntity.currentRoll) * 0.05f;
        this.root.f_104205_ = pEntity.currentRoll;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

