/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.vanimals.common.entity.ground.BisonEntity;
import net.reaper.vanimals.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractBisonModel
extends HierarchicalModel<BisonEntity> {
    protected final ModelPart root;
    protected final ModelPart bison;

    protected AbstractBisonModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.bison = this.root.m_171324_("bison");
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
        this.getHead().f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.getHead().f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void setupAnim(@NotNull BisonEntity bison, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        if (BisonEntity.STUNNED_TICKS.get((Entity)bison) <= 0) {
            if (!EntityUtils.isEntityMoving((Entity)bison, 0.05f)) {
                this.m_233381_(bison.idleAnimationState, this.idleAnimation(), ageInTicks);
            }
            this.m_233381_(bison.attackAnimationState, this.attackAnimation(), ageInTicks);
        } else {
            this.m_233381_(bison.stunnedAnimationState, this.stunnedAnimation(), ageInTicks);
        }
        if (bison.m_20142_()) {
            this.m_267799_(this.sprintAnimation(), limbSwing, limbSwingAmount, 1.0f, 1.0f);
        } else {
            this.m_267799_(this.walkAnimation(), limbSwing, limbSwingAmount, 4.0f, 4.5f);
        }
        this.root.f_104204_ = netHeadYaw * ((float)Math.PI / 360);
    }

    public abstract void setMatrixStack(@NotNull PoseStack var1);

    protected abstract ModelPart getHead();

    protected abstract AnimationDefinition idleAnimation();

    protected abstract AnimationDefinition attackAnimation();

    protected abstract AnimationDefinition stunnedAnimation();

    protected abstract AnimationDefinition sprintAnimation();

    protected abstract AnimationDefinition walkAnimation();
}

