/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.event;

import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.vanimals.client.VClientProxy;
import net.reaper.vanimals.client.event.ModelRotationEvent;
import net.reaper.vanimals.client.event.PlayerPoseEvent;
import net.reaper.vanimals.client.input.InputKey;
import net.reaper.vanimals.client.input.InputStateManager;
import net.reaper.vanimals.client.input.KeyPressType;
import net.reaper.vanimals.client.util.ICustomPlayerRidePos;
import net.reaper.vanimals.client.util.IDynamicCamera;
import net.reaper.vanimals.client.util.IShakeScreenOnStep;
import net.reaper.vanimals.client.util.PlayerScreenShaker;
import net.reaper.vanimals.common.network.packet_builder.CorePacket;
import net.reaper.vanimals.common.network.packet_builder.DataType;
import net.reaper.vanimals.common.network.packet_builder.Side;
import net.reaper.vanimals.common.util.RenderUtil;

@Mod.EventBusSubscriber(modid="vanimals", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class VClientsEvents {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent pEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_9236_().m_5776_()) {
            if (pEvent.phase == TickEvent.Phase.END) {
                player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_(15.0), entity -> entity instanceof IShakeScreenOnStep && entity.m_6084_()).forEach(arg_0 -> VClientsEvents.lambda$onClientTick$1((Player)player, arg_0));
            }
            if (pEvent.phase == TickEvent.Phase.START) {
                InputStateManager.getInstance().update();
                block0: for (InputKey inputKey : InputKey.values()) {
                    for (KeyPressType pressType : KeyPressType.values()) {
                        if (!InputStateManager.getInstance().isKeyPress(inputKey, pressType)) continue;
                        CorePacket packet = new CorePacket(1, Side.SERVER, new DataType[]{DataType.INTEGER, DataType.INTEGER}, new Object[]{inputKey.ordinal(), pressType.ordinal()});
                        continue block0;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key pEvent) {
        InputKey inputKey = InputKey.fromKeyCode(pEvent.getKey());
        if (inputKey != null) {
            InputStateManager.getInstance().updateKeyState(inputKey, pEvent.getAction() != 0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onComputeCameraAngle(ViewportEvent.ComputeCameraAngles pEvent) {
        Entity vehicle;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20159_() && (vehicle = player.m_20201_()) instanceof Mob) {
            Mob mob = (Mob)vehicle;
            if (vehicle instanceof IDynamicCamera) {
                IDynamicCamera dynamicCamera = (IDynamicCamera)vehicle;
                float targetRoll = Math.max(-dynamicCamera.getMaxCameraTilt(), Math.min(dynamicCamera.getMaxCameraTilt(), (mob.f_20883_ - mob.f_20884_) * dynamicCamera.getCameraTiltSpeed()));
                VClientProxy.currentRoll += (targetRoll - VClientProxy.currentRoll) * 0.1f;
                pEvent.setRoll(pEvent.getRoll() - VClientProxy.currentRoll);
            } else {
                VClientProxy.currentRoll += (0.0f - VClientProxy.currentRoll) * 0.1f;
                pEvent.setRoll(pEvent.getRoll() - VClientProxy.currentRoll);
            }
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity> void onPlayerPose(PlayerPoseEvent<T> pEvent) {
        Mob mob;
        Mob vehicle;
        EntityRenderer<Mob> entityRenderer;
        Entity entity;
        T entity2 = pEvent.getEntity();
        if (entity2 instanceof Player && (entity = entity2.m_20202_()) instanceof Mob && (entityRenderer = RenderUtil.getEntityRenderer(vehicle = (mob = (Mob)entity))) instanceof ICustomPlayerRidePos) {
            ICustomPlayerRidePos customRidePos = (ICustomPlayerRidePos)entityRenderer;
            customRidePos.applyRiderPose((LivingEntity)vehicle, pEvent.getHumanoidModel(), entity2);
        }
    }

    @SubscribeEvent
    public static <T extends LivingEntity> void onModelRotation(ModelRotationEvent<T> pEvent) {
        T entity = pEvent.getEntity();
        if (entity instanceof Player) {
            pEvent.setCanceled(RenderUtil.getEntityRenderer(entity.m_20202_()) instanceof ICustomPlayerRidePos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPrePlayerRender(RenderPlayerEvent.Pre pEvent) {
        Player player = pEvent.getEntity();
        RenderPlayerEvent.Post event = new RenderPlayerEvent.Post(player, pEvent.getRenderer(), pEvent.getPartialTick(), pEvent.getPoseStack(), pEvent.getMultiBufferSource(), pEvent.getPackedLight());
        Set<UUID> set = RenderUtil.hiddenEntities;
        synchronized (set) {
            if (RenderUtil.hiddenEntities.remove(player.m_20148_()) && RenderUtil.shouldSkipRendering(false, Minecraft.m_91087_().m_91288_())) {
                MinecraftForge.EVENT_BUS.post((Event)event);
                pEvent.setCanceled(true);
            }
        }
    }

    private static /* synthetic */ void lambda$onClientTick$1(Player player, Entity entity) {
        float shakePower;
        IShakeScreenOnStep screenShaker;
        if (entity instanceof IShakeScreenOnStep && (screenShaker = (IShakeScreenOnStep)entity).canEntityShake((LivingEntity)entity) && (shakePower = screenShaker.getShakePower() * (1.0f - player.m_20270_(entity) / screenShaker.getShakeDistance())) > 0.0f) {
            PlayerScreenShaker.startShake(15, shakePower);
        }
    }
}

