/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.api.io.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BufUtils {
    private BufUtils() {
        throw new RuntimeException("This is utility class!");
    }

    public static <T> void writeList(@NotNull FriendlyByteBuf buf, List<T> list, BiConsumer<FriendlyByteBuf, T> writer) {
        buf.m_130130_(list.size());
        for (T element : list) {
            writer.accept(buf, (FriendlyByteBuf)element);
        }
    }

    public static <T> List<T> readList(@NotNull FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader) {
        int size = buf.m_130242_();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(reader.apply(buf));
        }
        return list;
    }

    public static void writeVec3(@NotNull FriendlyByteBuf buf, @NotNull Vec3 vec) {
        buf.writeDouble(vec.f_82479_);
        buf.writeDouble(vec.f_82480_);
        buf.writeDouble(vec.f_82481_);
    }

    @NotNull
    public static Vec3 readVec3(@NotNull FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public static void writeBlockPos(@NotNull FriendlyByteBuf buf, @NotNull BlockPos pos) {
        buf.writeLong(pos.m_121878_());
    }

    @NotNull
    public static BlockPos readBlockPos(@NotNull FriendlyByteBuf buf) {
        return BlockPos.m_122022_((long)buf.readLong());
    }
}

