/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.api.common.misc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new RuntimeException("This is utility class!");
    }

    @NotNull
    public static <T> T instantiate(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class: " + clazz.getName(), e);
        }
    }

    public static Object getFieldValue(Object target, String fieldName) {
        try {
            Field field = ReflectionUtils.findField(target.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get field " + fieldName + " value on " + target, e);
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        try {
            Field field = ReflectionUtils.findField(target.getClass(), fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set field " + fieldName + " value on " + target, e);
        }
    }

    @NotNull
    public static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ignored) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field " + fieldName + " not found in " + clazz.getName());
    }

    public static boolean hasAnnotation(@NotNull Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    @NotNull
    public static <T extends Annotation> T getAnnotation(@NotNull Class<?> clazz, Class<T> annotationClass) {
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new IllegalStateException("Class " + clazz.getName() + " must be annotated with " + annotationClass.getName());
        }
        return annotation;
    }

    @NotNull
    public static List<Method> getMethodsWithAnnotation(@NotNull Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            result.add(method);
        }
        return result;
    }

    @NotNull
    public static List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static boolean hasFieldWithAnnotation(@NotNull Object obj, String fieldName, Class<? extends Annotation> annotationClass) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            return field.isAnnotationPresent(annotationClass);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

