/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.api.common.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.vanimals.Vanimals;
import net.reaper.vanimals.api.common.loot.LootPoolAccess;
import net.reaper.vanimals.api.common.loot.LootTableAccess;
import net.reaper.vanimals.core.init.VItems;

@Mod.EventBusSubscriber(modid="vanimals")
public class LootModifier {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLootTableModify(LootTableLoadEvent event) {
        if (event.getName().equals((Object)BuiltInLootTables.f_78720_)) {
            LootModifier.addToPool(event, LootItem.m_79579_((ItemLike)((ItemLike)VItems.RAW_FOUREYED_FISH.get())).m_79707_(20).m_7512_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78720_)) {
            LootModifier.addToPool(event, LootItem.m_79579_((ItemLike)((ItemLike)VItems.RAW_MUDSKIPPER.get())).m_79707_(10).m_7512_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78721_)) {
            LootModifier.addToPool(event, LootItem.m_79579_((ItemLike)((ItemLike)VItems.FOUREYED_FISH_EYE.get())).m_79707_(5).m_7512_());
        }
    }

    public static void addPool(LootTableLoadEvent event, LootPool.Builder pool) {
        List<LootPool> pools = ((LootTableAccess)event.getTable()).getPools();
        pools.add(pool.m_79082_());
    }

    public static boolean addToPool(LootTableLoadEvent event, int index, ArrayList<LootPoolEntryContainer> content) {
        LootTable table = event.getTable();
        try {
            List<LootPool> pools = ((LootTableAccess)table).getPools();
            if (pools.size() > index) {
                LootPool pool = pools.get(index);
                LootPoolEntryContainer[] entries = ((LootPoolAccess)pool).getEntries();
                ArrayList<LootPoolEntryContainer> modifiable = new ArrayList<LootPoolEntryContainer>(Arrays.asList(entries));
                modifiable.addAll(content);
                LootPoolEntryContainer[] modified = modifiable.toArray(new LootPoolEntryContainer[0]);
                ((LootPoolAccess)pool).setEntries(modified);
                return true;
            }
        }
        catch (Throwable t) {
            Vanimals.LOGGER.error("Failed to add content to loot pool at index {}: {}", new Object[]{index, t.getMessage(), t});
        }
        return false;
    }

    public static boolean addToPool(LootTableLoadEvent event, ArrayList<LootPoolEntryContainer> content) {
        return LootModifier.addToPool(event, 0, content);
    }

    public static boolean addToPool(LootTableLoadEvent event, int index, LootPoolEntryContainer ... content) {
        ArrayList<LootPoolEntryContainer> entries = new ArrayList<LootPoolEntryContainer>();
        Collections.addAll(entries, content);
        return LootModifier.addToPool(event, index, entries);
    }

    public static boolean addToPool(LootTableLoadEvent event, LootPoolEntryContainer ... content) {
        return LootModifier.addToPool(event, 0, content);
    }
}

