/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.datagen.providers;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.core.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> TRIM_MATERIALS = new LinkedHashMap();

    public ModItemModelProvider(PackOutput packOutput, String modId, ExistingFileHelper existingFileHelper) {
        super(packOutput, modId, existingFileHelper);
    }

    protected void registerModels() {
        this.itemModel(ModItems.NETHERITE_IRON_INGOT);
        this.itemModel(ModItems.NETHERITE_GOLD_INGOT);
        this.itemModel(ModItems.NETHERITE_EMERALD_INGOT);
        this.itemModel(ModItems.NETHERITE_DIAMOND_INGOT);
        this.armorModel(ModItems.NETHERITE_IRON_HELMET);
        this.armorModel(ModItems.NETHERITE_IRON_CHESTPLATE);
        this.armorModel(ModItems.NETHERITE_IRON_LEGGINGS);
        this.armorModel(ModItems.NETHERITE_IRON_BOOTS);
        this.armorModel(ModItems.NETHERITE_GOLD_HELMET);
        this.armorModel(ModItems.NETHERITE_GOLD_CHESTPLATE);
        this.armorModel(ModItems.NETHERITE_GOLD_LEGGINGS);
        this.armorModel(ModItems.NETHERITE_GOLD_BOOTS);
        this.armorModel(ModItems.NETHERITE_EMERALD_HELMET);
        this.armorModel(ModItems.NETHERITE_EMERALD_CHESTPLATE);
        this.armorModel(ModItems.NETHERITE_EMERALD_LEGGINGS);
        this.armorModel(ModItems.NETHERITE_EMERALD_BOOTS);
        this.armorModel(ModItems.NETHERITE_DIAMOND_HELMET);
        this.armorModel(ModItems.NETHERITE_DIAMOND_CHESTPLATE);
        this.armorModel(ModItems.NETHERITE_DIAMOND_LEGGINGS);
        this.armorModel(ModItems.NETHERITE_DIAMOND_BOOTS);
        this.toolModel(ModItems.NETHERITE_IRON_AXE);
        this.toolModel(ModItems.NETHERITE_GOLD_AXE);
        this.toolModel(ModItems.NETHERITE_EMERALD_AXE);
        this.toolModel(ModItems.NETHERITE_DIAMOND_AXE);
        this.toolModel(ModItems.NETHERITE_IRON_HOE);
        this.toolModel(ModItems.NETHERITE_GOLD_HOE);
        this.toolModel(ModItems.NETHERITE_EMERALD_HOE);
        this.toolModel(ModItems.NETHERITE_DIAMOND_HOE);
        this.toolModel(ModItems.NETHERITE_IRON_PICKAXE);
        this.toolModel(ModItems.NETHERITE_GOLD_PICKAXE);
        this.toolModel(ModItems.NETHERITE_EMERALD_PICKAXE);
        this.toolModel(ModItems.NETHERITE_DIAMOND_PICKAXE);
        this.toolModel(ModItems.NETHERITE_IRON_SHOVEL);
        this.toolModel(ModItems.NETHERITE_GOLD_SHOVEL);
        this.toolModel(ModItems.NETHERITE_EMERALD_SHOVEL);
        this.toolModel(ModItems.NETHERITE_DIAMOND_SHOVEL);
        this.toolModel(ModItems.NETHERITE_IRON_SWORD);
        this.toolModel(ModItems.NETHERITE_GOLD_SWORD);
        this.toolModel(ModItems.NETHERITE_EMERALD_SWORD);
        this.toolModel(ModItems.NETHERITE_DIAMOND_SWORD);
    }

    public void itemModel(Item item, ResourceLocation texture) {
        this.singleTexture(item.toString(), this.mcLoc("item/generated"), "layer0", texture);
    }

    @Internal
    private void itemModel(Item item) {
        this.itemModel(item, new ResourceLocation("advancednetherite", "item/" + item.toString()));
    }

    public void toolModel(Item item, ResourceLocation texture) {
        this.singleTexture(item.toString(), this.mcLoc("item/handheld"), "layer0", texture);
    }

    @Internal
    private void toolModel(Item item) {
        this.toolModel(item, new ResourceLocation("advancednetherite", "item/" + item.toString()));
    }

    public void armorModel(Item item) {
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        TRIM_MATERIALS.forEach((trimMaterial, trimValue) -> {
            ResourceLocation id = AdvancedNetherite.getRegistryHelper().getItemById((Item)armorItem);
            String armorType = switch (armorItem.m_40402_()) {
                case EquipmentSlot.HEAD -> "helmet";
                case EquipmentSlot.CHEST -> "chestplate";
                case EquipmentSlot.LEGS -> "leggings";
                case EquipmentSlot.FEET -> "boots";
                default -> "";
            };
            ResourceLocation armorTexture = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
            ResourceLocation trimTexture = this.mcLoc("trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_());
            ResourceLocation currentTrimTexture = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_() + "_" + trimMaterial.m_135782_().m_135815_() + "_trim");
            this.existingFileHelper.trackGenerated(trimTexture, PackType.CLIENT_RESOURCES, ".png", "textures");
            this.trimmedArmorModel(currentTrimTexture, armorTexture, trimTexture);
            this.nonTrimmedArmorModel(id, currentTrimTexture, trimValue.floatValue());
        });
    }

    private void trimmedArmorModel(ResourceLocation currentTrimTexture, ResourceLocation armorTexture, ResourceLocation trimTexture) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimTexture.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorTexture)).texture("layer1", trimTexture);
    }

    private void nonTrimmedArmorModel(ResourceLocation id, ResourceLocation currentTrimTexture, float trimValue) {
        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(currentTrimTexture)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
    }

    static {
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

