/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.utils.structure;

import carbonconfiglib.api.IEntrySettings;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.structure.StructureCompound;
import carbonconfiglib.utils.structure.StructureList;
import java.util.function.Function;

public interface IStructuredData {
    public StructureType getDataType();

    public IEntrySettings getSettings();

    default public SimpleData asSimple() {
        throw new IllegalStateException("Type isn't a Simple Structure");
    }

    default public StructureCompound.CompoundData asCompound() {
        throw new IllegalStateException("Type isn't a Compound Structure");
    }

    default public StructureList.ListData asList() {
        throw new IllegalStateException("Type isn't a List Structure");
    }

    public void appendFormat(StringBuilder var1, boolean var2);

    public String generateDefaultValue(Function<SimpleData, String> var1);

    public static enum EntryDataType {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING,
        ENUM,
        CUSTOM(true);

        SimpleData simple;

        private EntryDataType() {
            this(false);
        }

        private EntryDataType(boolean custom) {
            this.simple = custom ? null : SimpleData.of(this);
        }

        public SimpleData toSimpleType() {
            return this.simple;
        }

        public SimpleData toConfiguredType(IEntrySettings settings) {
            return settings == null ? this.simple : this.simple.withSettings(settings);
        }
    }

    public static enum StructureType {
        SIMPLE,
        COMPOUND,
        LIST;

    }

    public static class SimpleData
    implements IStructuredData {
        EntryDataType dataType;
        Class<?> variant;
        IEntrySettings settings;

        private SimpleData(EntryDataType dataType, Class<?> variant, IEntrySettings settings) {
            this.dataType = dataType;
            this.variant = variant;
            this.settings = settings;
        }

        public static SimpleData variant(EntryDataType type, Class<?> variant) {
            return new SimpleData(type, variant, null);
        }

        private static SimpleData of(EntryDataType type) {
            return new SimpleData(type, null, null);
        }

        @Override
        public StructureType getDataType() {
            return StructureType.SIMPLE;
        }

        @Override
        public IEntrySettings getSettings() {
            return this.settings;
        }

        @Override
        public SimpleData asSimple() {
            return this;
        }

        public EntryDataType getType() {
            return this.dataType;
        }

        public Class<?> getVariant() {
            return this.variant;
        }

        public boolean isVariant() {
            return this.variant != null;
        }

        public SimpleData withSettings(IEntrySettings settings) {
            return new SimpleData(this.dataType, this.variant, settings);
        }

        @Override
        public void appendFormat(StringBuilder builder, boolean start) {
            builder.append(Helpers.firstLetterUppercase(this.dataType.name().toLowerCase()));
        }

        @Override
        public String generateDefaultValue(Function<SimpleData, String> defaultFactory) {
            return defaultFactory.apply(this);
        }
    }
}

