/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CarbonIconButton
extends AbstractButton {
    Consumer<CarbonIconButton> listener;
    Icon icon;
    boolean iconOnly = false;
    int hash;

    public CarbonIconButton(int x, int y, int width, int height, Icon icon, Component name, Consumer<CarbonIconButton> listener) {
        super(x, y, width, height, name);
        this.listener = listener;
        this.icon = icon;
        this.hash = name.getString().hashCode();
    }

    public CarbonIconButton setIconOnly() {
        this.iconOnly = true;
        return this;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float p_93679_) {
        int k = this.getTextureY();
        graphics.blitWithBorder(f_93617_, this.m_252754_(), this.m_252907_(), 0, 46 + k * 20, this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
        if (this.iconOnly) {
            int j = this.getFGColor();
            RenderSystem.setShaderColor((float)((float)(j >> 16 & 0xFF) / 255.0f), (float)((float)(j >> 8 & 0xFF) / 255.0f), (float)((float)(j & 0xFF) / 255.0f), (float)1.0f);
            GuiUtils.drawTextureRegion(graphics, (float)(this.m_252754_() + this.f_93618_ / 2) - 5.5f, (float)(this.m_252907_() + this.f_93619_ / 2) - 5.5f, 11.0f, 11.0f, this.icon, 16.0f, 16.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int width = font.m_92852_((FormattedText)this.m_6035_()) + 21;
        float minX = this.m_252754_() + 4 + this.f_93618_ / 2 - width / 2;
        int j = this.getFGColor();
        RenderSystem.setShaderColor((float)((float)(j >> 16 & 0xFF) / 255.0f), (float)((float)(j >> 8 & 0xFF) / 255.0f), (float)((float)(j & 0xFF) / 255.0f), (float)1.0f);
        GuiUtils.drawTextureRegion(graphics, minX, this.m_252907_() + (this.f_93619_ - 8) / 2, 11.0f, 11.0f, this.icon, 16.0f, 16.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtils.drawScrollingShadowString(graphics, font, this.m_6035_(), minX + 15.0f, this.m_252907_(), width, this.f_93619_ - 2, ConfigElement.GuiAlign.CENTER, this.getFGColor(), this.hash);
    }

    private int getTextureY() {
        if (!this.f_93623_) {
            return 0;
        }
        if (this.m_198029_()) {
            return 2;
        }
        return 1;
    }

    public void m_5691_() {
        if (this.listener == null) {
            return;
        }
        this.listener.accept(this);
    }

    public void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }
}

