/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ListSelectionScreen
extends ListScreen {
    INode node;
    NodeSupplier supplier;
    Screen parent;
    Button apply;
    Runnable abortListener;
    Runnable successListener;
    boolean dontWarn;

    public ListSelectionScreen(Screen parent, INode node, NodeSupplier supplier, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.parent = parent;
        this.supplier = supplier;
        this.node = node;
        this.node.createTemp();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.visibleList.m_93471_(true);
        this.loadDefault();
        this.visibleList.setCallback(T -> this.setValue(((SelectionElement)((Object)T)).getSuggestion().getValue()));
        int x = this.f_96543_ / 2 - 100;
        int y = this.f_96544_;
        this.apply = (Button)this.m_142416_((GuiEventListener)new CarbonButton(x + 10, y - 27, 85, 20, (Component)Component.m_237115_((String)"gui.carbonconfig.pick"), this::save));
        this.m_142416_((GuiEventListener)new CarbonButton(x + 105, y - 27, 85, 20, (Component)Component.m_237115_((String)"gui.carbonconfig.cancel"), this::cancel));
    }

    public ListSelectionScreen withListener(Runnable success, Runnable abort) {
        this.successListener = success;
        this.abortListener = abort;
        return this;
    }

    public ListSelectionScreen disableAbortWarning() {
        this.dontWarn = true;
        return this;
    }

    protected void loadDefault() {
        this.findDefault(this.supplier.getValue(this.node));
    }

    protected void setValue(String value) {
        this.supplier.setValue(this.node, value);
    }

    protected void findDefault(String defaultValue) {
        for (Element element : this.allEntries) {
            if (!((SelectionElement)element).getSuggestion().getValue().equals(defaultValue)) continue;
            this.visibleList.setSelected(element);
            break;
        }
        this.visibleList.scrollToSelected(true);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(Comparator.comparing(Element::getName, String.CASE_INSENSITIVE_ORDER));
        return list;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.apply.f_93623_ = this.node.isChanged();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (ISuggestionProvider.Suggestion entry : this.supplier.getSuggestions(this.node)) {
            elements.accept(new SelectionElement(entry, this.visibleList));
        }
    }

    public void m_7379_() {
        this.abort();
        this.f_96541_.m_91152_(this.parent);
    }

    private void save(Button button) {
        this.node.apply();
        if (this.successListener != null) {
            this.successListener.run();
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void cancel(Button button) {
        if (this.node.isChanged() && !this.dontWarn) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.abort();
                }
                this.f_96541_.m_91152_((Screen)(T ? this.parent : this));
            }, (Component)Component.m_237115_((String)"gui.carbonconfig.warn.changed"), (Component)Component.m_237115_((String)"gui.carbonconfig.warn.changed.desc").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        this.abort();
        this.f_96541_.m_91152_(this.parent);
    }

    private void abort() {
        this.node.setPrevious();
        if (this.abortListener != null) {
            this.abortListener.run();
        }
    }

    public static class NodeSupplier {
        Function<INode, String> getter;
        BiConsumer<INode, String> setter;
        Function<INode, List<ISuggestionProvider.Suggestion>> provider;

        private NodeSupplier(Function<INode, String> getter, BiConsumer<INode, String> setter, Function<INode, List<ISuggestionProvider.Suggestion>> provider) {
            this.getter = getter;
            this.setter = setter;
            this.provider = provider;
        }

        public static NodeSupplier ofValue() {
            return new NodeSupplier(T -> T.asValue().get(), (N, S) -> N.asValue().set((String)S), T -> T.asValue().getSuggestions());
        }

        public static NodeSupplier ofCompound(IArrayNode node) {
            return new NodeSupplier(T -> T.asCompound().get(), (N, S) -> N.asCompound().set((String)S), T -> node.getSuggestions());
        }

        public String getValue(INode node) {
            return this.getter.apply(node);
        }

        public List<ISuggestionProvider.Suggestion> getSuggestions(INode node) {
            return this.provider.apply(node);
        }

        public void setValue(INode node, String value) {
            this.setter.accept(node, value);
        }
    }

    private class SelectionElement
    extends Element {
        ISuggestionProvider.Suggestion suggestion;
        ElementList myList;
        int lastClick;
        ISuggestionRenderer renderer;
        boolean loaded;

        public SelectionElement(ISuggestionProvider.Suggestion suggestion, ElementList list) {
            super((Component)Component.m_237115_((String)suggestion.getName()));
            this.lastClick = -1;
            this.loaded = false;
            this.suggestion = suggestion;
            this.myList = list;
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Component comp;
            ISuggestionRenderer renderer = this.getRenderer();
            if (renderer != null && (comp = renderer.renderSuggestion(graphics, this.suggestion.getValue(), left, top)) != null && mouseX >= left && mouseX <= left + 20 && mouseY >= top && mouseY <= top + 20) {
                this.owner.addTooltips(comp);
            }
            this.renderText(graphics, (Component)Component.m_237119_().m_130940_(this.myList.m_93511_() == this ? ChatFormatting.YELLOW : ChatFormatting.WHITE).m_7220_(this.name), left + (renderer != null ? 20 : 0), top, width - 5, height - 1, ConfigElement.GuiAlign.LEFT, -1);
        }

        private ISuggestionRenderer getRenderer() {
            if (this.loaded) {
                return this.renderer;
            }
            this.loaded = true;
            if (this.suggestion.getType() != null) {
                this.renderer = ISuggestionRenderer.Registry.getRendererForType(this.suggestion.getType());
            }
            return this.renderer;
        }

        public ISuggestionProvider.Suggestion getSuggestion() {
            return this.suggestion;
        }

        public boolean m_6375_(double p_94737_, double p_94738_, int p_94739_) {
            if (this.myList.m_93511_() == this) {
                if (this.lastClick >= 0 && this.myList.getLastTick() - this.lastClick <= 5) {
                    ListSelectionScreen.this.save(null);
                    return true;
                }
                this.lastClick = this.myList.getLastTick();
            } else {
                this.lastClick = this.myList.getLastTick();
            }
            this.myList.setSelected(this);
            return true;
        }
    }
}

