/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ForgeHelpers {
    public static void saveConfig(Path path, CommentedConfig data) {
        Helpers.ensureFolder(path.getParent());
        data.configFormat().createWriter().write((UnmodifiableConfig)data, path, WritingMode.REPLACE);
    }

    public static void saveConfig(CommentedConfig data, ModConfig config) {
        config.getConfigData().putAll((UnmodifiableConfig)data);
        config.save();
        ModList.get().getModContainerById(config.getModId()).ifPresent(T -> T.dispatchConfigEvent(IConfigEvent.reloading((ModConfig)config)));
    }

    public static ParseResult<Boolean> parseBoolean(String value) {
        return ParseResult.success(Boolean.parseBoolean(value));
    }

    public static ParseResult<String> parseString(String value) {
        return ParseResult.success(value);
    }

    public static ParseResult<Long> parseLong(String value) {
        try {
            return ParseResult.success(Long.parseLong(value));
        }
        catch (Exception e) {
            return ParseResult.error(value, e, "Couldn't parse Number");
        }
    }

    public static ParseResult<Float> parseFloat(String value) {
        try {
            return ParseResult.success(Float.valueOf(Float.parseFloat(value)));
        }
        catch (Exception e) {
            return ParseResult.error(value, e, "Couldn't parse Number");
        }
    }

    public static String getFloatLimit(Object[] value) {
        return ForgeHelpers.getLimit(value, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
    }

    public static String getDoubleLimit(Object[] value) {
        return ForgeHelpers.getLimit(value, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static String getLongLimit(Object[] value) {
        return ForgeHelpers.getLimit(value, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static String getIntLimit(Object[] value) {
        return ForgeHelpers.getLimit(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static String getLimit(Object[] value, Object min, Object max) {
        if (value[0] instanceof Number && value[1] instanceof Number) {
            if (value[0].equals(min)) {
                if (value[1].equals(max)) {
                    return "";
                }
                return "Range: < " + value[1];
            }
            if (value[1].equals(max)) {
                if (value[0].equals(min)) {
                    return "";
                }
                return "Range: > " + value[0];
            }
            return "Range: " + value[0] + " ~ " + value[1];
        }
        return "";
    }

    public static Object[] getRangeInfo(ForgeConfigSpec.ValueSpec spec) {
        ForgeConfigSpec.Range obj = spec.getRange();
        if (obj == null) {
            return null;
        }
        try {
            Class<?> rangeClass = Class.forName("net.minecraftforge.common.ForgeConfigSpec$Range");
            return new Object[]{ObfuscationReflectionHelper.getPrivateValue(rangeClass, (Object)obj, (String)"min"), ObfuscationReflectionHelper.getPrivateValue(rangeClass, (Object)obj, (String)"max")};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

