// noinspection ES6ConvertVarToLetConst

var ASM = Java.type('net.minecraftforge.coremod.api.ASMAPI');
var Opcodes = Java.type('org.objectweb.asm.Opcodes');

var MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
var VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');

// noinspection JSUnusedGlobalSymbols
function initializeCoreMod() {

    return {
        'axesareweps': {
            'target': {
                'type': 'METHOD',
                'class': 'net.minecraft.world.item.enchantment.EnchantmentCategory$6', // WEAPON
                'methodName': ASM.mapMethod('m_7454_'), // canEnchant
                'methodDesc': '(Lnet/minecraft/world/item/Item;)Z'
            },
            'transformer': function (/*org.objectweb.asm.tree.MethodNode*/ methodNode) {
                var /*org.objectweb.asm.tree.InsnList*/ instructions = methodNode.instructions;
                instructions.insertBefore(
                    ASM.findFirstInstruction(methodNode, Opcodes.IRETURN),
                    ASM.listOf(
                        new VarInsnNode(Opcodes.ALOAD, 1),
                        new MethodInsnNode(
                            Opcodes.INVOKESTATIC,
                            'tamaized/voidscape/asm/ASMHooks',
                            'axesRWeps',
                            '(ZLnet/minecraft/world/item/Item;)Z',
                            false
                            )
                        )
                    );
                return methodNode;
            }
        }
    }
}
