/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.init.TFLoot;

public class GiantPickUsedCondition
implements LootItemCondition {
    final LootContext.EntityTarget entityTarget;

    private GiantPickUsedCondition(LootContext.EntityTarget pEntityTarget) {
        this.entityTarget = pEntityTarget;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)TFLoot.GIANT_PICK_USED_CONDITION.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.entityTarget.m_79003_());
    }

    public boolean test(LootContext context) {
        Player player;
        GiantPickMineCapability capability;
        Object object = context.m_78953_(this.entityTarget.m_79003_());
        if (object instanceof Player && (capability = (GiantPickMineCapability)(player = (Player)object).getCapability(CapabilityList.GIANT_PICK_MINE).resolve().orElse(null)) != null) {
            return player.m_9236_().m_46467_() == capability.getMining() && capability.canMakeGiantBlock();
        }
        return false;
    }

    public static LootItemCondition.Builder builder(LootContext.EntityTarget target) {
        return () -> new GiantPickUsedCondition(target);
    }

    public static class ConditionSerializer
    implements Serializer<GiantPickUsedCondition> {
        public void serialize(JsonObject json, GiantPickUsedCondition condition, JsonSerializationContext context) {
            json.add("entity", context.serialize((Object)condition.entityTarget));
        }

        public GiantPickUsedCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new GiantPickUsedCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }
    }
}

