/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.entity.boss.Lich;
import twilightforest.init.TFSounds;
import twilightforest.item.LifedrainScepterItem;
import twilightforest.util.EntityUtil;

public class LichPopMobsGoal
extends Goal {
    private final Lich lich;

    public LichPopMobsGoal(Lich lich) {
        this.lich = lich;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.lich.setScepterTime();
    }

    public void m_8041_() {
        super.m_8041_();
        this.lich.resetScepterTime();
    }

    public boolean m_8036_() {
        return !this.lich.isShadowClone() && this.lich.m_21223_() < this.lich.m_21233_() && this.lich.getPopCooldown() == 0 && !this.lich.m_9236_().m_6443_(Mob.class, this.lich.m_20191_().m_82377_(32.0, 16.0, 32.0), e -> e.m_6095_().m_204039_(EntityTagGenerator.LICH_POPPABLES) && this.lich.m_142582_((Entity)e)).isEmpty();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.lich.getScepterTimeLeft() > 0) {
            return;
        }
        for (Mob mob : this.lich.m_9236_().m_6443_(Mob.class, this.lich.m_20191_().m_82377_(32.0, 16.0, 32.0), e -> e.m_6095_().m_204039_(EntityTagGenerator.LICH_POPPABLES))) {
            if (!this.lich.m_21574_().m_148306_((Entity)mob) || this.lich.m_9236_().m_5776_()) continue;
            mob.m_146870_();
            LifedrainScepterItem.animateTargetShatter((ServerLevel)this.lich.m_9236_(), (LivingEntity)mob);
            SoundEvent deathSound = EntityUtil.getDeathSound((LivingEntity)mob);
            if (deathSound != null) {
                this.lich.m_9236_().m_5594_(null, mob.m_20183_(), deathSound, SoundSource.HOSTILE, 1.0f, mob.m_6100_());
            }
            this.lich.m_5496_((SoundEvent)TFSounds.LICH_POP_MOB.get(), 3.0f, 0.4f + this.lich.m_217043_().m_188501_() * 0.2f);
            mob.m_5496_((SoundEvent)TFSounds.LICH_POP_MOB.get(), 3.0f, 0.4f + this.lich.m_217043_().m_188501_() * 0.2f);
            this.lich.makeMagicTrail(mob.m_146892_(), this.lich.m_146892_(), 1.0f, 0.5f, 0.5f);
            this.lich.m_5634_(2.0f);
            this.lich.m_6674_(InteractionHand.MAIN_HAND);
            this.lich.setPopCooldown(40);
            this.lich.m_146850_(GameEvent.f_223707_);
            break;
        }
    }
}

