/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.HugeLilypadPiece;

public class HugeLilyPadBlock
extends WaterlilyBlock {
    public static final DirectionProperty FACING = TFHorizontalBlock.f_54117_;
    public static final EnumProperty<HugeLilypadPiece> PIECE = EnumProperty.m_61587_((String)"piece", HugeLilypadPiece.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private boolean isSelfDestructing = false;

    public HugeLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PIECE, (Comparable)((Object)HugeLilypadPiece.NW)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING, PIECE}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.isSelfDestructing) {
            this.setGiantBlockToAir(level, pos, state);
        }
    }

    private void setGiantBlockToAir(Level level, BlockPos pos, BlockState state) {
        this.isSelfDestructing = true;
        for (BlockPos check : this.getAllMyBlocks(pos, state)) {
            BlockState stateThere = level.m_8055_(check);
            if (stateThere.m_60734_() != this) continue;
            level.m_46961_(check, false);
        }
        this.isSelfDestructing = false;
    }

    public List<BlockPos> getAllMyBlocks(BlockPos pos, BlockState state) {
        ArrayList pieces = Lists.newArrayListWithCapacity((int)4);
        if (state.m_60734_() == this) {
            BlockPos nwPos = switch ((HugeLilypadPiece)((Object)state.m_61143_(PIECE))) {
                case HugeLilypadPiece.NE -> pos.m_122024_();
                case HugeLilypadPiece.SE -> pos.m_122012_().m_122024_();
                case HugeLilypadPiece.SW -> pos.m_122012_();
                default -> pos;
            };
            pieces.add(nwPos);
            pieces.add(nwPos.m_122019_());
            pieces.add(nwPos.m_122029_());
            pieces.add(nwPos.m_122019_().m_122029_());
        }
        return pieces;
    }
}

