/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GiantBlock
extends Block {
    private boolean isSelfDestructing;

    public GiantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (BlockPos dPos : GiantBlock.getVolume(context.m_8083_())) {
            if (context.m_43725_().m_8055_(dPos).m_60629_(context)) continue;
            return null;
        }
        return this.m_49966_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.m_5776_()) {
            for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                level.m_46597_(dPos, this.m_49966_());
            }
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!this.isSelfDestructing && !this.isVolumeFilled(level, pos)) {
            this.setGiantBlockToAir(level, pos);
        }
    }

    private void setGiantBlockToAir(Level level, BlockPos pos) {
        this.isSelfDestructing = true;
        for (BlockPos iterPos : GiantBlock.getVolume(pos)) {
            if (pos.equals((Object)iterPos) || level.m_8055_(iterPos).m_60734_() != this) continue;
            level.m_46961_(iterPos, false);
        }
        this.isSelfDestructing = false;
    }

    private boolean isVolumeFilled(Level level, BlockPos pos) {
        for (BlockPos dPos : GiantBlock.getVolume(pos)) {
            if (level.m_8055_(dPos).m_60734_() == this) continue;
            return false;
        }
        return true;
    }

    public static Iterable<BlockPos> getVolume(BlockPos pos) {
        return BlockPos.m_121976_((int)(pos.m_123341_() & 0xFFFFFFFC), (int)(pos.m_123342_() & 0xFFFFFFFC), (int)(pos.m_123343_() & 0xFFFFFFFC), (int)(pos.m_123341_() | 3), (int)(pos.m_123342_() | 3), (int)(pos.m_123343_() | 3));
    }
}

