/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.control;

import cofh.core.common.network.packet.server.RedstoneControlPacket;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.lib.api.control.IRedstoneControllable;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class RedstoneControlModule
implements IRedstoneControllable {
    protected IRedstoneControllableTile tile;
    protected Supplier<Boolean> enabled;
    protected int power;
    protected int threshold;
    protected IRedstoneControllable.ControlMode mode = IRedstoneControllable.ControlMode.DISABLED;

    public RedstoneControlModule(IRedstoneControllableTile tile) {
        this(tile, Constants.TRUE);
    }

    public RedstoneControlModule(IRedstoneControllableTile tile, Supplier<Boolean> enabled) {
        this.tile = tile;
        this.enabled = enabled;
    }

    public RedstoneControlModule setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.power = buffer.readByte();
        this.threshold = buffer.readByte();
        this.mode = IRedstoneControllable.ControlMode.VALUES[buffer.readByte()];
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte(this.power);
        buffer.writeByte(this.threshold);
        buffer.writeByte(this.mode.ordinal());
    }

    public RedstoneControlModule read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("RSControl");
        if (!subTag.m_128456_()) {
            this.power = subTag.m_128445_("RSPower");
            this.threshold = subTag.m_128445_("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.m_128445_("RSMode")];
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.isControllable()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128344_("RSPower", (byte)this.power);
            subTag.m_128344_("RSThreshold", (byte)this.threshold);
            subTag.m_128344_("RSMode", (byte)this.mode.ordinal());
            nbt.m_128365_("RSControl", (Tag)subTag);
        }
        return nbt;
    }

    public RedstoneControlModule readSettings(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("RSControl");
        if (!subTag.m_128456_() && this.isControllable()) {
            this.threshold = subTag.m_128445_("RSThreshold");
            this.mode = !this.isControllable() ? IRedstoneControllable.ControlMode.DISABLED : IRedstoneControllable.ControlMode.VALUES[subTag.m_128445_("RSMode")];
        }
        return this;
    }

    public CompoundTag writeSettings(CompoundTag nbt) {
        if (this.isControllable()) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128344_("RSThreshold", (byte)this.threshold);
            subTag.m_128344_("RSMode", (byte)this.mode.ordinal());
            nbt.m_128365_("RSControl", (Tag)subTag);
        }
        return nbt;
    }

    @Override
    public boolean isControllable() {
        return this.enabled.get();
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IRedstoneControllable.ControlMode getMode() {
        return this.mode;
    }

    @Override
    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public void setControl(int threshold, IRedstoneControllable.ControlMode mode) {
        int curThreshold = this.threshold;
        IRedstoneControllable.ControlMode curMode = this.mode;
        this.threshold = threshold;
        this.mode = mode;
        if (Utils.isClientWorld(this.tile.world())) {
            RedstoneControlPacket.sendToServer(this.tile);
            this.threshold = curThreshold;
            this.mode = curMode;
        } else {
            this.tile.onControlUpdate();
        }
    }
}

