/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container.pattern;

import com.glodblock.github.extendedae.container.pattern.ContainerPattern;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;

public class PatternGuiHandler {
    private static final Object2ObjectMap<String, IContainerPattern> factory = new Object2ObjectOpenHashMap();
    private static final Object2ReferenceMap<String, MenuType<?>> types = new Object2ReferenceOpenHashMap();
    private static final BiMap<Integer, String> internal = HashBiMap.create();
    private static int IDZ = 0;

    public static void open(Player player, String id, ItemStack pattern) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        MutableComponent title = Component.m_237115_((String)("epp.pattern." + id));
        SimpleMenuProvider menu = new SimpleMenuProvider((wnd, p, pl) -> {
            IContainerPattern f = (IContainerPattern)factory.get((Object)id);
            MenuType t = (MenuType)types.get((Object)id);
            return f.create(t, wnd, player.m_9236_(), pattern);
        }, (Component)title);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, buffer -> PatternGuiHandler.to(id, pattern, buffer));
    }

    private static AbstractContainerMenu from(int containerId, Inventory inv, FriendlyByteBuf packetBuf) {
        int id = packetBuf.m_130242_();
        Level world = inv.f_35978_.m_9236_();
        ItemStack stack = packetBuf.m_130267_();
        IContainerPattern f = (IContainerPattern)factory.get(internal.get((Object)id));
        MenuType t = (MenuType)types.get(internal.get((Object)id));
        return f.create(t, containerId, world, stack);
    }

    private static void to(String id, ItemStack pattern, FriendlyByteBuf packetBuf) {
        packetBuf.m_130130_(((Integer)internal.inverse().get((Object)id)).intValue());
        packetBuf.writeItemStack(pattern, false);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> register(String id, IContainerPattern containerFactory) {
        factory.put((Object)id, (Object)containerFactory);
        internal.put((Object)IDZ, (Object)id);
        ++IDZ;
        MenuType type = IForgeMenuType.create(PatternGuiHandler::from);
        types.put((Object)id, (Object)type);
        return type;
    }

    @FunctionalInterface
    public static interface IContainerPattern {
        public ContainerPattern create(MenuType<?> var1, int var2, Level var3, ItemStack var4);
    }
}

