/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterEndGatewayFeature {
    private static final List<StructureProcessor> PROCESSORS = List.of(new DragonEggProcessor());

    public static boolean place(FeaturePlaceContext<EndGatewayConfiguration> ctx) {
        ServerLevel serverLevel;
        BlockPos origin = ctx.m_159777_();
        WorldGenLevel level = ctx.m_159774_();
        EndGatewayConfiguration config = (EndGatewayConfiguration)ctx.m_159778_();
        int numberTimesDragonKilled = 0;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8586_() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.m_8586_()).betterendisland$numTimesDragonKilled();
        }
        ResourceLocation template = new ResourceLocation("betterendisland", "gateway");
        boolean placed = BetterEndGatewayFeature.placeTemplate((ServerLevelAccessor)level, ctx.m_225041_(), origin, template, numberTimesDragonKilled);
        BlockPos portalPos = new BlockPos((Vec3i)origin);
        level.m_7731_(portalPos, Blocks.f_50446_.m_49966_(), 3);
        config.m_67656_().ifPresent(exitPos -> {
            BlockEntity blockentity = level.m_7702_(portalPos);
            if (blockentity instanceof TheEndGatewayBlockEntity) {
                TheEndGatewayBlockEntity theendgatewayblockentity = (TheEndGatewayBlockEntity)blockentity;
                theendgatewayblockentity.m_59955_(exitPos, config.m_67657_());
                blockentity.m_6596_();
            }
        });
        return placed;
    }

    private static boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.m_6018_().m_215082_().m_230407_(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.m_7918_(-template.m_163801_().m_123341_() / 2, -template.m_163801_().m_123342_() / 2, -template.m_163801_().m_123343_() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).m_74383_(arg_0));
        structurePlaceSettings.m_74383_((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.m_74379_(Rotation.NONE);
        structurePlaceSettings.m_74385_(new BlockPos(1, 0, 1));
        template.m_230328_(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

