/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.network;

import cy.jdkdigital.dyenamics.Dyenamics;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SwagPacket {
    private final CompoundTag nbt;
    private final int entityID;

    public SwagPacket(int entityID, CompoundTag nbt) {
        this.nbt = nbt;
        this.entityID = entityID;
    }

    public static void encode(SwagPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityID);
        buf.m_130079_(msg.nbt);
    }

    public static SwagPacket decode(FriendlyByteBuf buf) {
        return new SwagPacket(buf.readInt(), buf.m_130260_());
    }

    public static class Handler {
        public static void handle(SwagPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world != null && (entity = world.m_6815_(message.entityID)) != null) {
                    entity.getCapability(Dyenamics.DYENAMIC_SWAG).ifPresent(swagProvider -> swagProvider.deserializeNBT((Tag)message.nbt));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

