/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.common.blockentity.DyenamicBedBlockEntity;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DyenamicBedRenderer
implements BlockEntityRenderer<DyenamicBedBlockEntity> {
    private final ModelPart headRoot;
    private final ModelPart footRoot;

    public DyenamicBedRenderer(BlockEntityRendererProvider.Context pContext) {
        this.headRoot = pContext.m_173582_(ModelLayers.f_171267_);
        this.footRoot = pContext.m_173582_(ModelLayers.f_171266_);
    }

    public void render(DyenamicBedBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Material material = Dyenamics.BED_MATERIAL_MAP.get(pBlockEntity.getColor().m_7912_());
        Level level = pBlockEntity.m_58904_();
        if (level != null) {
            BlockState blockstate = pBlockEntity.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)BlockEntityInit.BED.get()), BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)pBlockEntity.m_58899_(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(pPackedLight);
            this.renderPiece(pPoseStack, pBufferSource, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), material, i, pPackedOverlay, false);
        } else {
            this.renderPiece(pPoseStack, pBufferSource, this.headRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, false);
            this.renderPiece(pPoseStack, pBufferSource, this.footRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, true);
        }
    }

    private void renderPiece(PoseStack pPoseStack, MultiBufferSource pBufferSource, ModelPart pModelPart, Direction pDirection, Material pMaterial, int pPackedLight, int pPackedOverlay, boolean pFoot) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.5625, pFoot ? -1.0 : 0.0);
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + pDirection.m_122435_()));
        pPoseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexconsumer = pMaterial.m_119194_(pBufferSource, RenderType::m_110446_);
        pModelPart.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
    }
}

