/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.CryoStasis;
import cy.jdkdigital.productivebees.common.block.entity.CryoStasisBlockEntity;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class CryoStasisContainer
extends AbstractContainer {
    public final CryoStasisBlockEntity blockEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public CryoStasisContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CryoStasisContainer.getTileEntity(playerInventory, data));
    }

    public CryoStasisContainer(int windowId, Inventory playerInventory, CryoStasisBlockEntity blockEntity) {
        this((MenuType)ModContainerTypes.CRYO_STASIS.get(), windowId, playerInventory, blockEntity);
    }

    public CryoStasisContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, CryoStasisBlockEntity blockEntity) {
        super(type, windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, CryoStasisBlockEntity.SLOT_INPUT, 108, 18));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, CryoStasisBlockEntity.SLOT_CAGE, 108, 36));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, CryoStasisBlockEntity.SLOT_OUT, 108, 54));
        });
        this.layoutPlayerInventorySlots(playerInventory, 0, 108, 84);
    }

    private static CryoStasisBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof CryoStasisBlockEntity) {
            return (CryoStasisBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof CryoStasis && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

