/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public class IncubationRecipeCategory
implements IRecipeCategory<IncubationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public IncubationRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/incubator.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()));
    }

    public RecipeType<IncubationRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.INCUBATION_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.incubation");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IncubationRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 9, 9).addItemStacks(Arrays.stream(recipe.input.m_43908_()).toList())).setSlotName("input");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 37, 27).addItemStacks(Arrays.stream(recipe.catalyst.m_43908_()).toList())).setSlotName("catalyst");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 9).addItemStacks(Arrays.stream(recipe.result.m_43908_()).toList())).setSlotName("result");
    }

    public static List<IncubationRecipe> getRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<IncubationRecipe> recipes = new ArrayList<IncubationRecipe>();
        Bee bee = (Bee)EntityType.f_20550_.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        Bee baBee = (Bee)EntityType.f_20550_.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (bee != null && baBee != null) {
            ItemStack cage = new ItemStack((ItemLike)ModItems.BEE_CAGE.get());
            ItemStack babeeCage = cage.m_41777_();
            baBee.m_146762_(-24000);
            BeeCage.captureEntity(bee, cage);
            BeeCage.captureEntity(baBee, babeeCage);
            ItemStack treats = new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), ((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
            recipes.add(new IncubationRecipe(new ResourceLocation("productivebees", "cage_incubation"), (Ingredient)StrictNBTIngredient.of((ItemStack)babeeCage), Ingredient.m_43927_((ItemStack[])new ItemStack[]{treats}), (Ingredient)StrictNBTIngredient.of((ItemStack)cage)));
        }
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            StrictNBTIngredient spawnEgg = StrictNBTIngredient.of((ItemStack)BeeCreator.getSpawnEgg(entry.getKey()));
            StrictNBTIngredient treat = StrictNBTIngredient.of((ItemStack)HoneyTreat.getTypeStack(entry.getKey(), 100));
            recipes.add(new IncubationRecipe(new ResourceLocation(entry.getKey() + "_incubation"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), (Ingredient)treat, (Ingredient)spawnEgg));
        }
        return recipes;
    }
}

