/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModBlocks;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AdvancedBeehiveRecipeCategory
implements IRecipeCategory<AdvancedBeehiveRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public AdvancedBeehiveRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_produce_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.HIVES.get("advanced_oak_beehive").get()));
    }

    public RecipeType<AdvancedBeehiveRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.ADVANCED_BEEHIVE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.advanced_beehive");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvancedBeehiveRecipe recipe, IFocusGroup focuses) {
        if (recipe.ingredient.get() == null) {
            ProductiveBees.LOGGER.warn("Recipe is missing bee: " + recipe.m_6423_());
            return;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 7, 27).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)((BeeIngredient)recipe.ingredient.get()))).setSlotName("source");
        if (recipe.getRecipeOutputs().size() > 0) {
            int startX = 69;
            int startY = 27;
            int i = 0;
            for (Map.Entry<ItemStack, IntArrayTag> entry : recipe.getRecipeOutputs().entrySet()) {
                IntArrayTag countRange = entry.getValue();
                ArrayList innerList = new ArrayList();
                IntStream.range(countRange.get(0).m_7047_(), countRange.get(1).m_7047_() + 1).forEach(amount -> {
                    ItemStack newStack = ((ItemStack)entry.getKey()).m_41777_();
                    newStack.m_41764_(amount);
                    innerList.add(newStack);
                });
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i % 3 * 18, startY + (int)(Math.floor((float)i / 3.0f) * 18.0)).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                    int chance = countRange.get(2).m_7047_();
                    tooltip.add(Component.m_237110_((String)"productivebees.centrifuge.tooltip.chance", (Object[])new Object[]{chance < 1 ? "<1%" : chance + "%"}));
                    if (countRange.get(0) != countRange.get(1)) {
                        tooltip.add(Component.m_237110_((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{countRange.get(0).m_7047_() + " - " + countRange.get(1).m_7047_()}));
                    } else {
                        tooltip.add(Component.m_237113_((String)""));
                    }
                }).setSlotName("output" + i);
                ++i;
            }
        }
    }
}

