/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.harvest;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.harvest.MinecraftHarvester;
import cy.jdkdigital.productivebees.compat.harvest.PamsHarvester;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraftforge.fml.ModList;

public class HarvestCompatHandler {
    public static boolean isCropValid(ProductiveBee bee, BlockPos pos) {
        boolean isValid = MinecraftHarvester.isCropValid(bee, pos);
        if (!isValid && ModList.get().isLoaded("pamhc2trees")) {
            isValid = PamsHarvester.isCropValid(bee, pos);
        }
        return isValid;
    }

    public static void harvestBlock(ProductiveBee bee, BlockPos pos) {
        AtomicBoolean hasHarvested = new AtomicBoolean(false);
        if (MinecraftHarvester.isCropValid(bee, pos)) {
            MinecraftHarvester.harvestBlock(bee, pos);
            hasHarvested.set(true);
        }
        if (!hasHarvested.get() && ModList.get().isLoaded("pamhc2trees") && PamsHarvester.isCropValid(bee, pos)) {
            PamsHarvester.harvestBlock(bee, pos);
            hasHarvested.set(true);
        }
    }
}

