/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class BeeNBTChangerRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> bee;
    public final Ingredient item;
    public String attribute;
    public String method;
    public int value;
    public int min;
    public int max;

    public BeeNBTChangerRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredients, Ingredient item, String attribute, String method, int value, int min, int max) {
        this.id = id;
        this.bee = ingredients;
        this.item = item;
        this.attribute = attribute;
        this.method = method;
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.ItemInventory && this.bee.get() != null) {
            String beeName = ((BeeHelper.ItemInventory)inv).getIdentifier(0);
            ItemStack item = ((BeeHelper.ItemInventory)inv).getInput();
            String parentName = ((BeeIngredient)this.bee.get()).getBeeType().toString();
            boolean matchesItem = false;
            for (ItemStack stack : this.item.m_43908_()) {
                CompoundTag tag;
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)item) || (tag = item.m_41783_()) == null || !tag.m_128441_(this.attribute) || tag.m_128451_(this.attribute) <= this.min || tag.m_128451_(this.attribute) >= this.max) continue;
                matchesItem = true;
            }
            return parentName.equals(beeName) && matchesItem;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_NBT_CHANGER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BEE_NBT_CHANGER_TYPE.get();
    }

    public static class Serializer<T extends BeeNBTChangerRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String beeName = GsonHelper.m_13906_((JsonObject)json, (String)"bee");
            Lazy bee = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
            Ingredient item = GsonHelper.m_13885_((JsonObject)json, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"item"));
            String attribute = GsonHelper.m_13906_((JsonObject)json, (String)"attribute");
            String method = GsonHelper.m_13906_((JsonObject)json, (String)"method");
            int value = GsonHelper.m_13824_((JsonObject)json, (String)"value", (int)0);
            int min = GsonHelper.m_13824_((JsonObject)json, (String)"min", (int)0);
            int max = GsonHelper.m_13824_((JsonObject)json, (String)"max", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)bee, item, attribute, method, value, min, max);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                BeeIngredient bee = BeeIngredient.fromNetwork(buffer);
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> bee), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130277_(), buffer.m_130277_(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeIngredient)((BeeNBTChangerRecipe)recipe).bee.get()).toNetwork(buffer);
                ((BeeNBTChangerRecipe)recipe).item.m_43923_(buffer);
                buffer.m_130070_(((BeeNBTChangerRecipe)recipe).attribute);
                buffer.m_130070_(((BeeNBTChangerRecipe)recipe).method);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).value);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).min);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).max);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BeeNBTChangerRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeNBTChangerRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Ingredient var3, String var4, String var5, int var6, int var7, int var8);
        }
    }
}

