/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Gene
extends Item {
    public static final String ATTRIBUTE_KEY = "productivebees_gene_attribute";
    public static final String VALUE_KEY = "productivebees_gene_value";
    public static final String PURITY_KEY = "productivebees_gene_purity";

    public static float color(ItemStack itemStack) {
        return switch (Gene.getAttributeName(itemStack)) {
            case "productivity" -> 0.1f;
            case "endurance" -> 0.2f;
            case "temper" -> 0.3f;
            case "behavior" -> 0.4f;
            case "weather_tolerance" -> 0.5f;
            default -> 0.0f;
        };
    }

    public Gene(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(BeeAttribute<Integer> attribute, int value) {
        return Gene.getStack(attribute, value, 1);
    }

    public static ItemStack getStack(BeeAttribute<Integer> attribute, int value, int count) {
        return Gene.getStack(attribute, value, count, ProductiveBees.random.m_188503_(40) + 15);
    }

    public static ItemStack getStack(BeeAttribute<Integer> attribute, int value, int count, int purity) {
        return Gene.getStack(attribute.toString(), value, count, purity);
    }

    public static ItemStack getStack(String type, int value) {
        return Gene.getStack(type, 0, 1, value);
    }

    public static ItemStack getStack(String attribute, int value, int count, int purity) {
        ItemStack result = new ItemStack((ItemLike)ModItems.GENE.get(), count);
        Gene.setAttribute(result, attribute, value, purity);
        return result;
    }

    public static void setAttribute(ItemStack stack, String attributeId, int value, int purity) {
        stack.m_41784_().m_128359_(ATTRIBUTE_KEY, attributeId);
        stack.m_41784_().m_128405_(VALUE_KEY, value);
        stack.m_41784_().m_128405_(PURITY_KEY, purity);
    }

    @Nullable
    public static BeeAttribute<Integer> getAttribute(ItemStack stack) {
        String name = Gene.getAttributeName(stack);
        return BeeAttributes.getAttributeByName(name);
    }

    public static String getAttributeName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(ATTRIBUTE_KEY) : "";
    }

    public static Integer getValue(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(VALUE_KEY) : 0;
    }

    public static Integer getPurity(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(PURITY_KEY) : 0;
    }

    public static void setPurity(ItemStack stack, int purity) {
        stack.m_41784_().m_128405_(PURITY_KEY, purity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        Integer value = Gene.getValue(stack);
        BeeAttribute<Integer> attribute = Gene.getAttribute(stack);
        if (attribute != null && BeeAttributes.keyMap.containsKey(attribute) && BeeAttributes.keyMap.get(attribute).containsKey(value)) {
            MutableComponent translatedValue = Component.m_237115_((String)BeeAttributes.keyMap.get(attribute).get(value)).m_130940_(ColorUtil.getAttributeColor(value));
            list.add((Component)Component.m_237110_((String)("productivebees.information.attribute." + Gene.getAttributeName(stack)), (Object[])new Object[]{translatedValue}).m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)(" (" + Gene.getPurity(stack) + "%)"))));
        } else {
            String type = Gene.getAttributeName(stack);
            list.add((Component)Component.m_237110_((String)"productivebees.information.attribute.type", (Object[])new Object[]{type}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(" (" + Gene.getPurity(stack) + "%)"))));
        }
    }
}

