/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

public class ShapeUtil {
    public static List<BlockPos> cubeSquareBase(BlockPos pos, int radius, int height) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_() - radius;
        int xMax = pos.m_123341_() + radius;
        int zMin = pos.m_123343_() - radius;
        int zMax = pos.m_123343_() + radius;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = pos.m_123342_(); y <= pos.m_123342_() + height; ++y) {
                    shape.add(new BlockPos(x, y, z));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalFull(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_() - radius;
        int xMax = pos.m_123341_() + radius;
        int zMin = pos.m_123343_() - radius;
        int zMax = pos.m_123343_() + radius;
        int y = pos.m_123342_();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> squareVerticalX(BlockPos pos, int xRadius, int yRadius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_() - xRadius;
        int xMax = pos.m_123341_() + xRadius;
        int yMin = pos.m_123342_() - yRadius;
        int yMax = pos.m_123342_() + yRadius;
        int z = pos.m_123343_();
        for (int y = yMin + 1; y < yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin + 1; y < yMax; ++y) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> squareVerticalZ(BlockPos pos, int yRadius, int zRadius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.m_123341_();
        int zMin = pos.m_123343_() - zRadius;
        int zMax = pos.m_123343_() + zRadius;
        int yMin = pos.m_123342_() - yRadius;
        int yMax = pos.m_123342_() + yRadius;
        for (int y = yMin + 1; y < yMax; ++y) {
            for (int z = zMin; z <= zMax; ++z) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin + 1; y < yMax; ++y) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> line(BlockPos pos, Direction efacing, int want) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int skip = 1;
        for (int i = 1; i < want + 1; i += skip) {
            shape.add(pos.m_5484_(efacing, i));
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalHollow(BlockPos pos, int radius) {
        return ShapeUtil.rectHollow(pos, radius, radius);
    }

    public static List<BlockPos> rect(BlockPos pos, BlockPos target) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        if (pos == null || target == null) {
            return shape;
        }
        int xMin = Math.min(pos.m_123341_(), target.m_123341_());
        int yMin = Math.min(pos.m_123342_(), target.m_123342_());
        int zMin = Math.min(pos.m_123343_(), target.m_123343_());
        int xMax = Math.max(pos.m_123341_(), target.m_123341_());
        int yMax = Math.max(pos.m_123342_(), target.m_123342_());
        int zMax = Math.max(pos.m_123343_(), target.m_123343_());
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = yMin; y <= yMax; ++y) {
                    shape.add(new BlockPos(x, y, z));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> rectHollow(BlockPos pos, int radiusX, int radiusZ) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_() - radiusX;
        int xMax = pos.m_123341_() + radiusX;
        int zMin = pos.m_123343_() - radiusZ;
        int zMax = pos.m_123343_() + radiusZ;
        int y = pos.m_123342_();
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> getShape(AABB ab, int y) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = (int)ab.f_82288_;
        int xMax = (int)ab.f_82291_ - 1;
        int zMin = (int)ab.f_82290_;
        int zMax = (int)ab.f_82293_ - 1;
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> circleVertical(BlockPos pos, int diameter, int maxHeight, Direction dir) {
        int radius;
        int diroff = dir.m_122421_() == Direction.AxisDirection.NEGATIVE ? -1 : 1;
        int centerY = pos.m_123342_();
        int radOffset = radius = diameter / 2;
        int otherOff = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        for (int i = 0; i < maxHeight; ++i) {
            radOffset = radius;
            otherOff = 0;
            d = 2 - 2 * radius;
            do {
                if (dir.m_122434_() == Direction.Axis.Z) {
                    centerH = pos.m_123341_();
                    circleList.add(new BlockPos(centerH + otherOff, centerY + radOffset, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH + otherOff, centerY - radOffset, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH - otherOff, centerY + radOffset, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH - otherOff, centerY - radOffset, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH + radOffset, centerY + otherOff, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH + radOffset, centerY - otherOff, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH - radOffset, centerY + otherOff, pos.m_123343_() + diroff * i));
                    circleList.add(new BlockPos(centerH - radOffset, centerY - otherOff, pos.m_123343_() + diroff * i));
                } else {
                    centerH = pos.m_123343_();
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY + radOffset, centerH + otherOff));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY - radOffset, centerH + otherOff));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY + radOffset, centerH - otherOff));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY - radOffset, centerH - otherOff));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY + otherOff, centerH + radOffset));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY - otherOff, centerH + radOffset));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY + otherOff, centerH - radOffset));
                    circleList.add(new BlockPos(pos.m_123341_() + diroff * i, centerY - otherOff, centerH - radOffset));
                }
                if (d < 0) {
                    d = d + 4 * otherOff + 6;
                    continue;
                }
                d = d + 4 * (otherOff - radOffset) + 10;
                --radOffset;
            } while (++otherOff <= radOffset);
        }
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.m_123341_() - object2.m_123341_();
            }
        });
        return circleList;
    }

    public static List<BlockPos> circleHorizontal(BlockPos pos, int diameter) {
        int radius;
        int centerX = pos.m_123341_();
        int centerZ = pos.m_123343_();
        int height = pos.m_123342_();
        int z = radius = diameter / 2;
        int x = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        do {
            circleList.add(new BlockPos(centerX + x, height, centerZ + z));
            circleList.add(new BlockPos(centerX + x, height, centerZ - z));
            circleList.add(new BlockPos(centerX - x, height, centerZ + z));
            circleList.add(new BlockPos(centerX - x, height, centerZ - z));
            circleList.add(new BlockPos(centerX + z, height, centerZ + x));
            circleList.add(new BlockPos(centerX + z, height, centerZ - x));
            circleList.add(new BlockPos(centerX - z, height, centerZ + x));
            circleList.add(new BlockPos(centerX - z, height, centerZ - x));
            if (d < 0) {
                d = d + 4 * x + 6;
                continue;
            }
            d = d + 4 * (x - z) + 10;
            --z;
        } while (++x <= z);
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.m_123341_() - object2.m_123341_();
            }
        });
        return circleList;
    }

    public static List<BlockPos> repeatShapeByHeight(List<BlockPos> shape, int height) {
        ArrayList<BlockPos> newShape = new ArrayList<BlockPos>();
        newShape.addAll(shape);
        for (int i = 1; i <= Math.abs(height); ++i) {
            for (BlockPos p : shape) {
                BlockPos newOffset = null;
                newOffset = height > 0 ? p.m_6630_(i) : p.m_6625_(i);
                newShape.add(newOffset);
            }
        }
        return newShape;
    }

    public static List<BlockPos> sphereDome(BlockPos pos, int radius) {
        return ShapeUtil.sphere(pos, radius, true, false);
    }

    public static List<BlockPos> sphereCup(BlockPos pos, int radius) {
        return ShapeUtil.sphere(pos, radius, false, true);
    }

    public static List<BlockPos> sphere(BlockPos pos, int radius) {
        return ShapeUtil.sphere(pos, radius, false, false);
    }

    public static List<BlockPos> sphere(BlockPos pos, int radius, boolean topHalfOnly, boolean bottomHalfOnly) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int radiusInner = radius - 1;
        int yMin = y - radius;
        int yMax = y + radius;
        if (topHalfOnly) {
            yMin = pos.m_123342_();
        } else if (bottomHalfOnly) {
            yMax = pos.m_123342_();
        }
        for (int xCurr = x - radius; xCurr <= x + radius; ++xCurr) {
            for (int yCurr = yMin; yCurr <= yMax; ++yCurr) {
                for (int zCurr = z - radius; zCurr <= z + radius; ++zCurr) {
                    int squareDistance = (xCurr - x) * (xCurr - x) + (yCurr - y) * (yCurr - y) + (zCurr - z) * (zCurr - z);
                    if (squareDistance > radius * radius || squareDistance < radiusInner * radiusInner) continue;
                    shape.add(new BlockPos(xCurr, yCurr, zCurr));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> squarePyramid(BlockPos pos, int radius, int height) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int radiusCurrent = radius;
        BlockPos posCurrent = new BlockPos((Vec3i)pos);
        for (int i = 0; i < radius; ++i) {
            shape.addAll(ShapeUtil.rectHollow(posCurrent, radiusCurrent, radiusCurrent));
            --radiusCurrent;
            posCurrent = posCurrent.m_7494_();
        }
        return shape;
    }

    public static List<BlockPos> diagonal(BlockPos posCurrent, Direction pfacing, int want, boolean isLookingUp) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        for (int i = 1; i < want + 1; ++i) {
            posCurrent = isLookingUp ? posCurrent.m_7494_() : posCurrent.m_7495_();
            posCurrent = posCurrent.m_121945_(pfacing);
            shape.add(posCurrent);
        }
        return shape;
    }
}

