/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.particle.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleOptionsTwoInt
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ParticleOptionsTwoInt> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionsTwoInt>(){

        public ParticleOptionsTwoInt fromCommand(ParticleType<ParticleOptionsTwoInt> particleType, StringReader reader) throws CommandSyntaxException {
            if (reader.canRead()) {
                reader.expect(' ');
            }
            int oneInt = 0xFFFFFF;
            int twoInt = 0xFFFFFF;
            if (reader.canRead()) {
                oneInt = reader.readInt();
            }
            if (reader.canRead()) {
                reader.expect(' ');
            }
            if (reader.canRead()) {
                twoInt = reader.readInt();
            }
            return new ParticleOptionsTwoInt(particleType, oneInt, twoInt);
        }

        public ParticleOptionsTwoInt fromNetwork(ParticleType<ParticleOptionsTwoInt> particleType, FriendlyByteBuf buf) {
            return new ParticleOptionsTwoInt(particleType, buf.readInt(), buf.readInt());
        }
    };
    private final ParticleType<ParticleOptionsTwoInt> particleType;
    public int oneInt;
    public int twoInt;

    public ParticleOptionsTwoInt(ParticleType<ParticleOptionsTwoInt> particleType, int oneInt, int twoInt) {
        this.particleType = particleType;
        this.oneInt = oneInt;
        this.twoInt = twoInt;
    }

    public ParticleType<?> m_6012_() {
        return this.particleType;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.oneInt);
        buf.writeInt(this.twoInt);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.oneInt, this.twoInt);
    }
}

