/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildingUtils {
    public static final Predicate<JobEntry> UNRESTRICTED = job -> true;

    private BuildingUtils() {
    }

    public static ItemStack getItemStackForHutFromInventory(Inventory inventory, String hut) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)inventory.f_35978_, item -> item.m_41720_() instanceof BlockItem && ((BlockItem)item.m_41720_()).m_40614_() instanceof AbstractBlockHut && ForgeRegistries.BLOCKS.getKey((Object)((BlockItem)item.m_41720_()).m_40614_()).m_135815_().endsWith(hut));
        if (slot != -1) {
            return inventory.m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static Predicate<JobEntry> getAllowedJobs(@NotNull Level world, @NotNull BlockPos buildingPos) {
        IBlueprintDataProviderBE provider;
        Set jobTags;
        BlockEntity blockEntity = world.m_7702_(buildingPos);
        if (blockEntity instanceof IBlueprintDataProviderBE && !(jobTags = ((List)(provider = (IBlueprintDataProviderBE)blockEntity).getPositionedTags().getOrDefault(BlockPos.f_121853_, new ArrayList())).stream().filter(t -> t.startsWith("job=")).map(t -> t.substring(4)).collect(Collectors.toSet())).isEmpty()) {
            return job -> jobTags.contains(job.getKey().m_135815_()) || jobTags.contains(job.getKey().toString());
        }
        return UNRESTRICTED;
    }

    public static boolean canAutoHire(@NotNull IBuilding building, @NotNull HiringMode hiringMode, @Nullable JobEntry job) {
        return building.canAssignCitizens() && (hiringMode == HiringMode.DEFAULT && !building.getColony().isManualHiring() || hiringMode == HiringMode.AUTO) && (job == null || BuildingUtils.getAllowedJobs(building.getColony().getWorld(), building.getPosition()).test(job));
    }

    public static int getRotationFromBlueprint(@NotNull Level world, @NotNull BlockPos pos) {
        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            return -1;
        }
        try {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof IBlueprintDataProviderBE) {
                String path;
                IBlueprintDataProviderBE blueprintDataProvider = (IBlueprintDataProviderBE)blockEntity;
                String pack = blueprintDataProvider.getPackName();
                Blueprint blueprint = StructurePacks.getBlueprint((String)pack, (String)(path = blueprintDataProvider.getBlueprintPath()), (boolean)true);
                if (blueprint == null && path.endsWith("0.blueprint")) {
                    blueprint = StructurePacks.getBlueprint((String)pack, (String)path.replace("0.blueprint", "1.blueprint"), (boolean)true);
                }
                if (blueprint != null) {
                    BlockState worldState = world.m_8055_(pos);
                    BlockState structureState = ((BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset())).getState();
                    if (structureState != null) {
                        int structureRotation = BuildingUtils.getRotationFromBlock(structureState);
                        int worldRotation = BuildingUtils.getRotationFromBlock(worldState);
                        if (structureRotation == -1 || worldRotation == -1) {
                            Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", path));
                            return -1;
                        }
                        return (4 + worldRotation - structureRotation) % 4;
                    }
                }
                Log.getLogger().error(String.format("Failed to get rotation of building at pos: %s with path: %s", pos.m_123344_(), path));
            } else {
                Log.getLogger().error(String.format("Failed to get rotation of building at pos: %s", pos.m_123344_()));
            }
        }
        catch (Exception e) {
            Log.getLogger().error(String.format("Failed to get rotation of building at pos: %s", pos.m_123344_()), (Throwable)e);
        }
        return -1;
    }

    public static int getRotationFromBlock(@NotNull BlockState blockState) {
        if (blockState.m_60734_() instanceof AbstractBlockHut) {
            return ((Direction)blockState.m_61143_((Property)AbstractBlockHut.FACING)).m_122416_();
        }
        if (blockState.m_60734_() instanceof DirectionalBlock) {
            return ((Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_)).m_122416_();
        }
        return -1;
    }
}

