/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesGrave;
import com.minecolonies.api.blocks.types.GraveType;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityGrave
extends AbstractTileEntityGrave {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private static final String TAG_GRAVE_DATA = "gravedata";

    public TileEntityGrave(BlockEntityType<? extends TileEntityGrave> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityGrave>)type, pos, state);
    }

    public TileEntityGrave(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityGrave>)((BlockEntityType)MinecoloniesTileEntities.GRAVE.get()), pos, state);
    }

    @Override
    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void updateItemStorage() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.m_6596_();
        }
    }

    private void updateContent() {
        this.content.clear();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack)) continue;
            ItemStorage storage = new ItemStorage(stack.m_41777_());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof AbstractBlockMinecoloniesGrave) {
            BlockState state = (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(AbstractBlockMinecoloniesGrave.VARIANT, (Comparable)((Object)(this.decayed ? GraveType.DECAYED : GraveType.DEFAULT)));
            if (!this.f_58857_.m_8055_(this.f_58858_).equals(state)) {
                this.f_58857_.m_46597_(this.f_58858_, state);
            }
        }
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        this.updateContent();
        return this.content.isEmpty();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.decay_timer = compound.m_128441_("decaytimer") ? compound.m_128451_("decaytimer") : 12000;
        boolean bl = this.decayed = compound.m_128441_("decayed") ? compound.m_128471_("decayed") : false;
        if (compound.m_128441_(TAG_GRAVE_DATA)) {
            this.graveData = new GraveData();
            this.graveData.read(compound.m_128469_(TAG_GRAVE_DATA));
        } else {
            this.graveData = null;
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("decaytimer", this.decay_timer);
        compound.m_128379_("decayed", this.decayed);
        if (this.graveData != null) {
            compound.m_128365_(TAG_GRAVE_DATA, (Tag)this.graveData.write());
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130064_(this.m_58899_());
        return new ContainerGrave(id, inv, buffer);
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Grave");
    }

    public boolean onColonyTick(double delay) {
        if (this.m_58898_() && !this.f_58857_.f_46443_ && this.decay_timer != -1) {
            this.decay_timer = (int)((double)this.decay_timer - delay);
            if (this.decay_timer <= 0) {
                if (!this.decayed) {
                    this.decayed = true;
                    this.decay_timer = 12000;
                    this.updateBlockState();
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.inventory, this.f_58857_, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
                    this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                    return false;
                }
            }
        }
        return true;
    }
}

