/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchCosts;
import com.minecolonies.api.research.ModResearchEffects;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.research.GlobalResearch;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(ResourceLocation id, ResourceLocation parent, ResourceLocation branch, TranslatableContents name, TranslatableContents subtitle, int depth, int sortOrder, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        return new GlobalResearch(id, parent, branch, name, subtitle, depth, sortOrder, onlyChild, hidden, autostart, instant, immutable);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull IGlobalResearch research) {
        CompoundTag compound = new CompoundTag();
        if (research.getParent() != null) {
            compound.m_128359_("parent", research.getParent().toString());
        }
        compound.m_128359_("id", research.getId().toString());
        compound.m_128359_("branch", research.getBranch().toString());
        compound.m_128359_("name", research.getName().m_237508_());
        compound.m_128405_("depth", research.getDepth());
        compound.m_128405_("sort", research.getSortOrder());
        compound.m_128379_("onlyChild", research.hasOnlyChild());
        compound.m_128359_("subtitle", research.getSubtitle().m_237508_());
        compound.m_128379_("instant", research.isInstant());
        compound.m_128379_("autostart", research.isAutostart());
        compound.m_128379_("immutable", research.isImmutable());
        compound.m_128379_("hidden", research.isHidden());
        @NotNull ListTag costTagList = research.getCostList().stream().map(cost -> {
            CompoundTag costCompound = new CompoundTag();
            costCompound.m_128359_("cost-type", cost.getType().getRegistryName().toString());
            costCompound.m_128365_("cost-nbt", (Tag)cost.writeToNBT());
            return compound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("cost", (Tag)costTagList);
        @NotNull ListTag reqTagList = research.getResearchRequirements().stream().map(req -> {
            CompoundTag reqCompound = new CompoundTag();
            reqCompound.m_128359_("requirement-type", req.getRegistryEntry().getRegistryName().toString());
            reqCompound.m_128365_("requirement-item", (Tag)req.writeToNBT());
            return reqCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("requirements", (Tag)reqTagList);
        @NotNull ListTag effectTagList = research.getEffects().stream().map(eff -> {
            CompoundTag effectCompound = new CompoundTag();
            effectCompound.m_128359_("effect-type", eff.getRegistryEntry().getRegistryName().toString());
            effectCompound.m_128365_("effect-item", (Tag)eff.writeToNBT());
            return effectCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("effects", (Tag)effectTagList);
        @NotNull ListTag childTagList = research.getChildren().stream().map(child -> {
            CompoundTag childCompound = new CompoundTag();
            childCompound.m_128359_("child", child.toString());
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.m_128365_("hasResearchedChild", (Tag)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("id"));
        ResourceLocation parent = nbt.m_128441_("parent") ? new ResourceLocation(nbt.m_128461_("parent")) : null;
        ResourceLocation branch = new ResourceLocation(nbt.m_128461_("branch"));
        TranslatableContents name = new TranslatableContents(nbt.m_128461_("name"), null, TranslatableContents.f_237494_);
        TranslatableContents subtitle = new TranslatableContents(nbt.m_128461_("subtitle"), null, TranslatableContents.f_237494_);
        int depth = nbt.m_128451_("depth");
        int sortOrder = nbt.m_128451_("sort");
        boolean onlyChild = nbt.m_128471_("onlyChild");
        boolean instant = nbt.m_128471_("instant");
        boolean autostart = nbt.m_128471_("autostart");
        boolean immutable = nbt.m_128471_("immutable");
        boolean hidden = nbt.m_128471_("hidden");
        IGlobalResearch research = this.getNewInstance(id, parent, branch, name, subtitle, depth, sortOrder, onlyChild, hidden, autostart, instant, immutable);
        NBTUtils.streamCompound(nbt.m_128437_("cost", 10)).forEach(compound -> {
            ModResearchCosts.ResearchCostEntry researchCostType = (ModResearchCosts.ResearchCostEntry)IMinecoloniesAPI.getInstance().getResearchCostRegistry().getValue(new ResourceLocation(compound.m_128461_("cost-type")));
            research.addCost(researchCostType.readFromNBT(compound.m_128469_("cost-nbt")));
        });
        NBTUtils.streamCompound(nbt.m_128437_("requirements", 10)).forEach(compound -> research.addRequirement(Objects.requireNonNull((ModResearchRequirements.ResearchRequirementEntry)IMinecoloniesAPI.getInstance().getResearchRequirementRegistry().getValue(ResourceLocation.m_135820_((String)compound.m_128461_("requirement-type")))).readFromNBT(compound.m_128469_("requirement-item"))));
        NBTUtils.streamCompound(nbt.m_128437_("effects", 10)).forEach(compound -> research.addEffect(Objects.requireNonNull((ModResearchEffects.ResearchEffectEntry)IMinecoloniesAPI.getInstance().getResearchEffectRegistry().getValue(ResourceLocation.m_135820_((String)compound.m_128461_("effect-type")))).readFromNBT(compound.m_128469_("effect-item"))));
        NBTUtils.streamCompound(nbt.m_128437_("hasResearchedChild", 10)).forEach(compound -> research.addChild(new ResourceLocation(compound.m_128461_("child"))));
        return research;
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, IGlobalResearch input, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130085_(input.getId());
        packetBuffer.writeBoolean(input.getParent() != null);
        if (input.getParent() != null) {
            packetBuffer.m_130085_(input.getParent());
        }
        packetBuffer.m_130085_(input.getBranch());
        packetBuffer.m_130070_(input.getName().m_237508_());
        packetBuffer.m_130070_(input.getSubtitle().m_237508_());
        packetBuffer.m_130130_(input.getDepth());
        packetBuffer.m_130130_(input.getSortOrder());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        packetBuffer.writeBoolean(input.isInstant());
        packetBuffer.writeBoolean(input.isAutostart());
        packetBuffer.writeBoolean(input.isImmutable());
        packetBuffer.writeBoolean(input.isHidden());
        packetBuffer.m_130130_(input.getCostList().size());
        for (IResearchCost cost : input.getCostList()) {
            packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getResearchCostRegistry(), (Object)cost.getType());
            packetBuffer.m_130079_(cost.writeToNBT());
        }
        packetBuffer.m_130130_(input.getResearchRequirements().size());
        for (IResearchRequirement req : input.getResearchRequirements()) {
            packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getResearchRequirementRegistry(), (Object)req.getRegistryEntry());
            packetBuffer.m_130079_(req.writeToNBT());
        }
        packetBuffer.m_130130_(input.getEffects().size());
        for (IResearchEffect effect : input.getEffects()) {
            packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getResearchEffectRegistry(), (Object)effect.getRegistryEntry());
            packetBuffer.m_130079_(effect.writeToNBT());
        }
        packetBuffer.m_130130_(input.getChildren().size());
        for (ResourceLocation child : input.getChildren()) {
            packetBuffer.m_130085_(child);
        }
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        ResourceLocation id = buffer.m_130281_();
        ResourceLocation parent = buffer.readBoolean() ? buffer.m_130281_() : null;
        ResourceLocation branch = buffer.m_130281_();
        TranslatableContents name = new TranslatableContents(buffer.m_130277_(), null, TranslatableContents.f_237494_);
        TranslatableContents subtitle = new TranslatableContents(buffer.m_130277_(), null, TranslatableContents.f_237494_);
        int depth = buffer.m_130242_();
        int sortOrder = buffer.m_130242_();
        boolean hasOnlyChild = buffer.readBoolean();
        boolean instant = buffer.readBoolean();
        boolean autostart = buffer.readBoolean();
        boolean immutable = buffer.readBoolean();
        boolean hidden = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, parent, branch, name, subtitle, depth, sortOrder, hasOnlyChild, hidden, autostart, instant, immutable);
        int costSize = buffer.m_130242_();
        for (int i = 0; i < costSize; ++i) {
            ModResearchCosts.ResearchCostEntry researchCostEntry = (ModResearchCosts.ResearchCostEntry)buffer.readRegistryIdSafe(ModResearchCosts.ResearchCostEntry.class);
            research.addCost(researchCostEntry.readFromNBT(buffer.m_130260_()));
        }
        int reqCount = buffer.m_130242_();
        for (int i = 0; i < reqCount; ++i) {
            ModResearchRequirements.ResearchRequirementEntry researchRequirementEntry = (ModResearchRequirements.ResearchRequirementEntry)buffer.readRegistryIdSafe(ModResearchRequirements.ResearchRequirementEntry.class);
            research.addRequirement(researchRequirementEntry.readFromNBT(buffer.m_130260_()));
        }
        int effectCount = buffer.m_130242_();
        for (int i = 0; i < effectCount; ++i) {
            ModResearchEffects.ResearchEffectEntry researchEffectEntry = (ModResearchEffects.ResearchEffectEntry)buffer.readRegistryIdSafe(ModResearchEffects.ResearchEffectEntry.class);
            research.addEffect(researchEffectEntry.readFromNBT(buffer.m_130260_()));
        }
        int childCount = buffer.m_130242_();
        for (int i = 0; i < childCount; ++i) {
            research.addChild(buffer.m_130281_());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return 28;
    }
}

