/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.blocks.BlockMinecoloniesGrave;
import com.minecolonies.core.tileentities.TileEntityGrave;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravePlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.m_60734_() instanceof BlockMinecoloniesGrave;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        BlockEntity entity;
        if (world.m_8055_(pos).m_60734_() == ModBlocks.blockGrave) {
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
        world.m_7731_(pos, blockState, 3);
        if (tileEntityData != null) {
            PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
        }
        if ((entity = world.m_7702_(pos)) instanceof TileEntityGrave) {
            ((TileEntityGrave)entity).updateBlockState();
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        for (ItemStack stack : PlacementHandlers.getItemsFromTileEntity((CompoundTag)tileEntityData, (BlockState)blockState)) {
            if (ItemStackUtils.isEmpty((ItemStack)stack)) continue;
            itemList.add(stack);
        }
        return itemList;
    }
}

