/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.core.items.ItemAssistantHammer;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlayerAssistantBuildRequestMessage
extends AbstractColonyServerMessage {
    private int workorderID;
    private BlockPos interactPos;

    public PlayerAssistantBuildRequestMessage() {
    }

    public PlayerAssistantBuildRequestMessage(IColony colony, int workorderID, BlockPos interactPos) {
        super(colony);
        this.workorderID = workorderID;
        this.interactPos = interactPos;
    }

    @Override
    protected void toBytesOverride(FriendlyByteBuf buf) {
        buf.writeInt(this.workorderID);
        buf.m_130064_(this.interactPos);
    }

    @Override
    protected void fromBytesOverride(FriendlyByteBuf buf) {
        this.workorderID = buf.readInt();
        this.interactPos = buf.m_130135_();
    }

    @Override
    @Nullable
    public Action permissionNeeded() {
        return Action.PLACE_BLOCKS;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        IServerWorkOrder workOrder = colony.getWorkManager().getWorkOrder(this.workorderID);
        if (workOrder == null) {
            player.m_213846_((Component)Component.m_237113_((String)("Could not find workorder with id: " + this.workorderID)));
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (item instanceof ItemAssistantHammer) {
            ItemAssistantHammer hammer = (ItemAssistantHammer)item;
            hammer.placeBlock((Player)player, colony, workOrder, this.interactPos);
        }
    }
}

